package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxDiyixx;

import java.util.List;

/**
 * 地役权信息(GxYySqxxDiyixx)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:44
 */
public interface GxYySqxxDiyixxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param diyixxid 主键
     * @return 实例对象
     */
    GxYySqxxDiyixx get(Integer diyixxid);

    /**
     * 通过申请ID查询单条数据
     *
     * @param sqid 申请id
     * @return 实例对象
     */
    GxYySqxxDiyixx getBySqid(String sqid);

    /**
     * 新增数据
     *
     * @param gxYySqxxDiyixx 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxDiyixx gxYySqxxDiyixx);

    /**
     * 新增数据
     *
     * @param gxYySqxxDiyixx 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYySqxxDiyixx gxYySqxxDiyixx);

    /**
     * 修改数据
     *
     * @param gxYySqxxDiyixx 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxDiyixx gxYySqxxDiyixx);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList
     * @return 实例对象
     */
    List<GxYySqxxDiyixx> list(List<String> sqidList);

    /**
     * 通过slbh查询集合数据
     *
     * @param slbh
     * @return 实例对象
     */
    List<GxYySqxxDiyixx> listBySlbh(String slbh);

    /**
     * 通过sqidList删除数据
     *
     * @param sqidList
     * @return 影响行数
     */
    int deleteBySqidList(List<String> sqidList);


}

