package cn.gtmap.hlw.core.dto.rest.yh;

import cn.gtmap.hlw.core.dto.common.ResData;
import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import lombok.Data;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/1/10
 * @description
 */
@Data
public class YhResDTO<T> {
    /**
     * 响应头
     */
    private YhResHeadDTO head;
    /**
     * 响应数据
     */
    private T data;

    public static YhResDTO success(Object data) {
        YhResDTO tResDTO = new YhResDTO();
        tResDTO.setData(data);
        YhResHeadDTO resHeadDTO = new YhResHeadDTO();
        resHeadDTO.setCode(ErrorEnum.SUCCESS.getCode());
        resHeadDTO.setMsg("成功");
        tResDTO.setHead(resHeadDTO);
        return tResDTO;
    }

    public static YhResDTO success() {
        YhResDTO tResDTO = new YhResDTO();
        tResDTO.setData(null);
        YhResHeadDTO resHeadDTO = new YhResHeadDTO();
        resHeadDTO.setCode(ErrorEnum.SUCCESS.getCode());
        tResDTO.setHead(resHeadDTO);
        return tResDTO;
    }

    public static YhResDTO fail(String msg) {
        YhResDTO tResDTO = new YhResDTO();
        tResDTO.setData(null);
        YhResHeadDTO resHeadDTO = new YhResHeadDTO();
        resHeadDTO.setCode(ErrorEnum.FAIL.getCode());
        resHeadDTO.setMsg(msg);
        tResDTO.setHead(resHeadDTO);
        return tResDTO;
    }

    public static YhResDTO fail(String code, String msg) {
        YhResDTO tResDTO = new YhResDTO();
        YhResHeadDTO resHeadDTO = new YhResHeadDTO();
        resHeadDTO.setCode(code);
        resHeadDTO.setMsg(msg);
        tResDTO.setHead(resHeadDTO);
        return tResDTO;
    }
}
