package cn.gtmap.hlw.core.constant.jkgl;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/13 13:44
 * @description 接口管理常量
 */
public class JkglConstant {
    /**
     * 4.2.3 抵押首次创建流程接口
     */
    public static final String WWSQ_INIT_DYSC_WWSQXX = "yc.wwsq.init.dysc.wwsqxx.url";

    /**
     * 4.3.2 抵押注销创建流程接口
     */
    public static final String WWSQ_INIT_DYZX_WWSQXX = "yc.wwsq.init.dyzx.wwsqxx.url";

    /**
     * 5.4.1 产权选择
     */
    public static final String WWSQ_QUERY_CQZXX_URL = "yc.wwsq.query.cqzxx.url";

    /**
     * 5.4.1 产权选择
     */
    public static final String WWSQ_QUERY_CQZXX_OR_FWXX_URL = "yc.wwsq.query.cqzxx.or.fwxx.url";
    /**
     * 5.4.3 获取办件节点
     */
    public static final String WWSQ_QUERY_SLZT_URL = "yc.wwsq.query.slzt.url";

    /**
     * 5.4.6	获合同备案信息接口（商品房）
     */
    public static final String WWSQ_QUERY_SPF_BAHTXX_URL = "yc.wwsq.query.spf.bahtxx.url";

    /**
     * 5.4.6	获合同备案信息批量接口（商品房）
     */
    public static final String WWSQ_QUERY_SPF_BAHTXX_PL_URL = "yc.wwsq.query.spf.bahtxx.pl.url";

    /**
     * 5.4.6    根据合同编号获合同备案信息接口 (存量房)
     */
    public static final String WWSQ_QUERY_BAHTXX_URL = "yc.wwsq.query.bahtxx.url";
    /**
     * 5.4.6    根据合同编号获合同备案信息接口 (存量房)
     */
    public static final String WWSQ_QUERY_BAHTXX_PL_URL = "yc.wwsq.query.bahtxx.pl.url";

    /**
     * 5.4.7 个人档案查询接口 getDanxx grdacx
     */
    public static final String WWSQ_QUERY_DAXX_URL = "yc.wwsq.query.daxx.url";

    /**
     * 5.4.8 合肥外网证书真伪查询接口 queryZs
     */
    public static final String WWSQ_QUERY_ZSZW_URL = "yc.wwsq.query.zszw.url";

    /**
     * 5.4.9 外网抵押注销流程获取抵押产权信息接口
     */
    public static final String WWSQ_QUERY_ZXDYAQXX_CQXX_URL = "yc.wwsq.query.zxdyaqxx.cqxx.url";
    /**
     * 6.1.5外网抵押注销流程获取抵押产权信息接口（多个人同时查询）(2.0+3.0)
     */
    public static final String WWSQ_QUERY_BDCZMCX_URL = "yc.wwsq.bdczmcx.url";

    /**
     * 证明真伪查询
     */
    public static final String WWSQ_QUERY_ZMZW_URL = "yc.wwsq.query.zmzw.url";

    /**
     * 5.4.10	合肥产权证选择接口（分页查询）
     */
    public static final String WWSQ_QUERY_CQZXX_PAGE_URL = "yc.wwsq.query.cqzxx.page.url";

    /**
     * 5.4.11 抵押首次获取产权证信息
     */
    public static final String WWSQ_QUERY_DYSC_CQXX_URL = "yc.wwsq.query.dysc.cqxx.url";

    /**
     * 5.4.16	获取产权证号下所有抵押信息
     */
    public static final String WWSQ_QUERY_CQZDYXX_URL = "yc.wwsq.query.cqzdyxx.url";

    /**
     * 5.4.19 根据权利人和权利人证号、预告证明号获取预告信息（包括预告和预告抵押）
     */
    public static final String WWSQ_QUERY_YGXX_URL = "yc.wwsq.query.ygxx.url";

    /**
     * 5.4.21查询土地使用权接口（2.0+3.0）
     */
    public static final String WWSQ_QUERY_TDSYQXX_URL = "yc.wwsq.query.tdsyqxx.url";

    /**
     * 5.6.1 通用项目创建接口
     */
    public static final String WWSQ_INIT_WWSQXX = "yc.wwsq.init.wwsqxx.url";
    /**
     * 5.7.70 推送授权委托信息接口
     */
    public static final String WWSQ_INIT_SQWTXX = "yc.wwsq.init.sqwtxx.url";
    /**
     * 5.6.7 根据受让方家庭成员信息获取家庭成员房屋信息接口
     */
    public static final String WWSQ_QUERY_FWTC_URL = "yc.wwsq.query.fwtc.url";

    /**
     * 5.7.1 逻辑幢分页查询服务（2.0+3.0）
     */
    public static final String WWSQ_QUERY_LJZ_PAGE_URL = "yc.wwsq.query.ljz.page.url";

    /**
     * 5.7.2根据幢主键查询户室列表（2.0+3.0）
     */
    public static final String WWSQ_QUERY_HSXX_URL = "yc.wwsq.query.hsxx.url";

    /**
     * 5.7.3 根据项目主键查询产权基本信息
     */
    public static final String WWSQ_QUERY_CQXXBYXMID_URL = "yc.wwsq.query.cqxxbyxmid.url";

    /**
     * 5.7.4 根据不动产单元号查询限制权利
     */
    public static final String WWSQ_XZQL_BYBDCDYH_URL = "yc.wwsq.xzql.bybdcdyh.url";

    /**
     * 5.7.6根据不动产受理编号查询办件状态(3.0+2.0)
     */
    public static final String WWSQ_QUERY_BJJD_V1_URL = "yc.wwsq.query.bjjd.V1.url";

    /**
     * 5.7.9根据BDCDYH查询土地信息（2.0+3.0）
     */
    public static final String WWSQ_BDCDYH_TDXX_URL = "yc.wwsq.bdcdyh.tdxx.url";

    /**
     * 5.7.12 转移抵押合并流程创建接口
     */
    public static final String WWSQ_INIT_ZYDY_WWSQXX = "yc.wwsq.init.zydy.wwsqxx.url";

    /**
     * 5.7.13 根据坐落分页查询房屋信息（2.0+3.0）
     */
    public static final String WWSQ_QUERY_ZL_FWXX_URL = "yc.wwsq.query.zl.fwxx.url";

    /**
     * 5.7.14 根据BDCDYH查询房屋信息（2.0+3.0）
     */
    public static final String WWSQ_QUERY_BDCDYH_FWXX_URL = "yc.wwsq.query.bdcdyh.fwxx.url";


    /**
     * 5.7.14 根据BDCDYH查询房屋信息（2.0+3.0）(权籍比对)
     */
    public static final String WWSQ_BDCDYH_FWXX_URL = "yc.wwsq.bdcdyh.fwxx.url";

    /**
     * 5.7.14 根据BDCDYH查询土地信息（2.0+3.0）(权籍比对)
     */
    public static final String WWSQ_BDCDYH_QJBD_TDXX_URL = "yc.wwsq.bdcdyh.qjbd.tdxx.url";

    /**
     * 5.7.20根据幢主键查询预测户室列表
     */
    public static final String WWSQ_QUERY_YC_HSXX_URL = "yc.wwsq.query.yc.hsxx.url";
    /**
     * 5.7.21外网根据受理编号查询收费收税信息
     */
    public static final String YC_HQJFMX_DJ_URL = "yc.hqjfmx.dj.url";

    /**
     * 5.7.27分页抵押查询抵押信息和预告抵押信息
     */
    public static final String WWSQ_QUERY_DYXXANDYGDYXX_URL = "yc.wwsq.query.dyxxAndYgdyxx.url";

    /**
     * 5.7.36月结缴费数据查询
     */
    public static final String YC_YJ_YJJFCX_URL = "yc.yj.yjjfcx.url";

    /**
     * 5.7.37生成月结单号
     */
    public static final String YC_YJ_SCYJDH_URL = "yc.yj.scyjdh.url";
    /**
     * 5.7.38月结更新缴费状态
     */
    public static final String YC_YJ_GXJFZT_URL = "yc.yj.gxjfzt.url";

    /**
     * 5.7.46 地役证明信息查询
     */
    public static final String WWSQ_QUERY_DIYIXX_ZM_URL = "yc.wwsq.query.diyixx.zm.url";

    /**
     * 5.7.47 异议证明查询
     */
    public static final String WWSQ_QUERY_YYZM_URL = "yc.wwsq.query.yyzm.url";

    /**
     * 5.7.49分 页查询土地承包经营信息
     */
    public static final String WWSQ_QUERY_TDCBJYXX_PAGE_URL = "yc.wwsq.query.tdcbjyxx.page.url";

    /**
     * 5.7.50 分页查询土地经营信息
     */
    public static final String WWSQ_QUERY_TDJYXX_PAGE_URL = "yc.wwsq.query.tdjyxx.page.url";

    /**
     * 5.7.51 分页查询土地承包经营权信息
     */
    public static final String WWSQ_QUERY_TDCBJYQXX_PAGE_URL = "yc.wwsq.query.tdcbjyqxx.page.url";

    /**
     * 5.7.52 查询土地承包经营权信息
     */
    public static final String WWSQ_QUERY_TDCBJYQXX_URL = "yc.wwsq.query.tdcbjyqxx.url";
    /**
     * 5.7.53 分页查询土地经营权信息
     */
    public static final String WWSQ_QUERY_TDJYQXX_PAGE_URL = "yc.wwsq.query.tdjyqxx.page.url";
    /**
     * 5.7.54 查询土地经营权信息
     */
    public static final String WWSQ_QUERY_TDJYQXX_URL = "yc.wwsq.query.tdjyqxx.url";
    /**
     * 5.7.57 苏小登统计数据查询（2.0+3.0）
     */
    public static final String YC_WWSQ_BJLTJ_URL = "yc.wwsq.bjltj.url";

    /**
     * 5.7.58 居住权信息查询
     */
    public static final String WWSQ_QUERY_JZQXX_URL = "yc.wwsq.query.jzqxx.url";

    /**
     * 5.7.59 推送物信息接口
     */
    public static final String YC_PUSH_WLXX_URL = "yc.push.wlxx.url";

    /**
     * 5.7.60 查询户室列表（办过首次的）
     */
    public static final String WWSQ_QUERY_HSLB_URL = "yc.wwsq.query.hslb.url";

    /**
     * 5.7.61 获取维修基金费率接口地址
     */
    public static final String WYC_HQWXJJFL_URL = "yc.query.wxjjfl.url";
    /**
     * 5.7.63 第三方附件(抵押物清单)下载
     */
    public static final String WWSQ_FJ_THIRD_DYWQD_DOWNLOAD_URL = "yc.wwsq.fj.third.dywqd.download.url";

    /**
     * 5.7.64月结缴费数据查询（不分页）
     */
    public static final String YC_YJ_YJJFXXCX_URL = "yc.yj.yjjfxxcx.url";

    /**
     * 5.7.65部门信息查询
     */
    public static final String WWSQ_BMXXCX_URL = "wwsq.bmxxcx.url";

    /**
     * 5.7.69登记资料查询申请（3.0）
     */
    public static final String WWSQ_DJZLCXSQ_URL = "wwsq.djzlcxsq.url";

    /**
     * 6.1.1 登记办件进度查询
     */
    public static final String WWSQ_QUERY_BJJD_URL = "yc.wwsq.query.bjjd.url";

    /**
     * 6.1.5 外网抵押注销流程获取抵押产权信息接口（多个人同时查询）(2.0+3.0)
     */

    /**
     * 6.1.7  分页查询产权信息（查封登记）
     */
    public static final String WWSQ_QUERY_CFCQZXX_PAGE_URL = "yc.wwsq.query.cfcqzxx.page.url";

    /**
     * 6.1.8    不动产单元信息查询（分页查询）
     */
    public static final String WWSQ_QUERY_BDCDYXX_PAGE_URL = "yc.wwsq.query.bdcdyxx.page.url";

    /**
     * 6.1.9 查封信息查询（解封、续封）
     */
    public static final String WWSQ_QUERY_CFXX_URL = "yc.wwsq.query.cfxx.url";

    /**
     * 6.1.26 通用项目验证接口
     */
    public static final String WWSQ_QUERY_CHECK_WWSQXX_URL = "yc.wwsq.query.check.wwsqxx.url";

    /**
     * 6.1.37 证照信息分页查询接口
     */
    public static final String WWSQ_QUERY_DZZZ_FY_URL = "yc.wwsq.query.dzzz.fy.url";

    /**
     * 6.1.40 抵押到期提醒查询
     */
    public static final String WWSQ_QUERY_DYDQTX_URL = "yc.wwsq.query.dydqtx.url";

    /**
     * 6.1.41 他行抵押查询
     */
    public static final String WWSQ_QUERY_THDYXX_URL = "yc.wwsq.query.thdyxx.url";

    /**
     * 6.1.42 查封登记查询
     */
    public static final String WWSQ_QUERY_CFDJXX_URL = "yc.wwsq.query.cfdjxx.url";

    /**
     * 6.1.43 异议登记查询
     */
    public static final String WWSQ_QUERY_YYDJXX_URL = "yc.wwsq.query.yydjxx.url";

    /**
     * 6.1.44 拆迁冻结查询
     */
    public static final String WWSQ_QUERY_CQDJXX_URL = "yc.wwsq.query.cqdjxx.url";

    /**
     * 6.1.45 首次登记证明查询地址
     */
    public static final String WWSQ_QUERY_SCDJZM_URL = "yc.wwsq.query.scdjzmcx.url";

    /**
     * 6.1.46 统计抵押登记信息
     */
    public static final String WWSQ_QUERY_COUNT_DYDJXX_URL = "yc.wwsq.query.count.dydjxx.url";

    /**
     * 6.1.51 林权信息查询
     */
    public static final String WWSQ_QUERY_LQXX_URL = "yc.wwsq.query.lqxx.url";

    /**
     * 6.1.52 林地信息查询
     */
    public static final String WWSQ_QUERY_LDXX_URL = "yc.wwsq.query.ldxx.url";

    /**
     * 林地经营信息查询
     */
    public static final String WWSQ_QUERY_LDJYXX_URL = "yc.wwsq.query.ldjyxx.url";

    /**
     * 林地经营权信息查询
     */
    public static final String WWSQ_QUERY_LDJYQXX_URL = "yc.wwsq.query.ldjyqxx.url";

    /**
     * 6.1.53 住房信息查询
     */
    public static final String WWSQ_QUERY_ZFXX_URL = "yc.query.zfxx.url";

    /**
     * 6.1.60 居住权登记查询
     */
    public static final String WWSQ_QUERY_JZQDJXX_URL = "yc.wwsq.query.jzqdjxx.url";
    /**
     * 6.1.63 住建转移信息查询（常州）
     */
    public static final String WWSQ_QUERY_ZJZYXX_URL = "yc.wwsq.query.zjzyxx.url";
    /**
     * 6.1.66 登记办件查询(2.0+3.0)
     */
    public static final String WWSQ_QUERY_DJBJCX_URL = "yc.wwsq.query.djbjcx.url";

    /**
     * 区域代码
     */
    public static final String REGISTER_DWDM = "register.dwdm";

    /**
     * 短信验证码发送接口地址
     */
    public static final String SMS_YZM_URL = "yc.sms.yzm.url";

    /**
     * 居住权流程创建接口
     */
    public static final String WWSQ_INIT_JZQ_WWSQXX = "yc.wwsq.init.jzq.wwsqxx.url";

    /**
     * 在线匹配信息推送登记接口
     */
    public static final String WWSQ_INIT_ZXPP_WWSQXX = "yc.wwsq.init.zxpp.wwsqxx.url";

    /**
     * 推送附件
     */
    public static final String WWSQ_TSWWSQFJXX_URL = "yc.wwsq.tsWwsqFjxx.url";
    /**
     * 删除附件
     */
    public static final String WWSQ_DELWWSQFJXX_URL = "yc.wwsq.delWwsqFjxx.url";
    /**
     * 推送退件申请
     */
    public static final String WWSQ_TSWWSQTJSQ_URL = "yc.wwsq.tsWwsqTjsq.url";
    /**
     * 推送移交单信息
     */
    public static final String WWSQ_TSWWYJDXX_URL = "yc.wwsq.tsWwYjdxx.url";

    /**
     * word 转 pdf
     */
    public static final String OFFICE_PDF_EXPORT_URL = "yc.office.pdf.export.url";

    /**
     * 上传打印模板
     */
    public static final String OFFICE_FILE_UPLOAD_URL = "yc.office.file.upload.url";

    /**
     * 下载打印模板
     */
    public static final String OFFICE_FILE_DYMB_DOWNLOAD_URL = "yc.office.file.dymb.download.url";
    /**
     * 获取受理编号
     */
    public static final String TYQZXT_GETSLBH_URL = "yc.tyqzxt.getSlbh.url";

    /**
     * 省厅共享接口地址
     */
    public static final String WWSQ_QUERY_STGX_URL = "yc.wwsq.query.stgx.url";

    /**
     * 省厅人像比对
     */
    public static final String WWSQ_QUERY_STGX_RXBD_URL = "yc.wwsq.query.stgx.rxbd.url";

    /**
     * 2.1.3.创建签署流程接口
     */
    public static final String CURRENCY_SIGNFLOWS_CREATE_URL = "yc.currency.signflows.create.url";
    /**
     * 2.1.8.签署流程撤销接口
     */
    public static final String CURRENCY_SIGNFLOWS_REVOKE_URL = "yc.currency.signflows.revoke.url";
    /**
     * 视频办云签接口
     */
    public static final String CURRENCY_SPB_SIGNFLOWS_CREATE_URL = "yc.currency.spb.signflows.create.url";

    /**
     * 2.1.5.签署详情查询接口
     */
    public static final String CURRENCY_SIGNFLOWS_QUERY_URL = "yc.currency.signflows.query.url";

    /**
     * 印章信息保存接口
     */
    public static final String CURRENCY_SIGNFLOWS_SAVEYZXX_URL = "yc.currency.signflows.saveyzxx.url";

    /**
     * 签署流程催办接口
     */
    public static final String CURRENCY_SIGNFLOWS_URGING_URL = "yc.currency.signflows.urging.url";

    /**
     * 2.1.6.签署文件下载接口
     */
    public static final String CURRENCY_SIGNFLOWS_DOWNLOAD_URL = "yc.currency.signflows.download.url";

    /**
     * 2.2.1.静默盖章流程接口
     */
    public static final String CURRENCY_SIGNFLOWS_SILENT_MODE_CREATE_URL = "yc.currency.signflows.silent.mode.create.url";

    /**
     * 获取签名设备信息地址
     */
    public static final String CURRENCY_SIGNFLOWS_QMSBXX_QUERY_URL = "yc.currency.signflows.qmsbxx.query.url";

    /**
     * 会签短息通知地址
     */
    public static final String HLW_SENDMSG_CURRENCY_URL = "yc.hlw.sendmsg.currency.url";

    /**
     * 查询配偶信息(民政信息)
     */
    public static final String WWSQ_QUERY_POXX_URL = "yc.wwsq.query.poxx.url";
    /**
     * 查询家庭成员信息(公安信息)
     */
    public static final String WWSQ_QUERY_JTCYXX_URL = "yc.wwsq.query.jtcyxx.url";

    /**
     * 企业身份信息验证
     */
    public static final String WWSQ_QUERY_ORG_SFYZ_URL = "yc.wwsq.query.org.sfyz.url";

    /**
     * 个人身份信息验证
     */
    public static final String WWSQ_QUERY_PERSON_SFYZ_URL = "yc.wwsq.query.person.sfyz.url";

    /**
     * 交易备案信息推送前验证接口
     */
    public static final String JYXX_BAXX_PUSH_CHECK_URL = "yc.jyxx.baxx.push.check.url";
    /**
     * 交易备案信息推送接口
     */
    public static final String JYXX_BAXX_PUSH_URL = "yc.jyxx.baxx.push.url";

    /**
     * 交易备案信息推送前--房源核验申请接口
     */
    public static final String JYXX_BAXX_PUSH_FYHY_URL = "yc.jyxx.baxx.push.fyhy.url";

    /**
     * 交易备案--状态改变通知交易系统接口
     */
    public static final String JYXX_BAXX_NOTICE_URL = "yc.jyxx.baxx.notice.url";

    /**
     * 交易备案信息合同推送接口
     */
    public static final String JYXX_BAXX_PUSHHT_URL = "yc.jyxx.baxx.pushht.url";


    /**
     * 交易备案免监管申请推送接口
     */
    public static final String JYXX_MJG_PUSH_URL = "yc.jyxx.mjg.push.url";


    /**
     * 交易备案免监管申请推送接口
     */
    public static final String JYXX_MJG_ZTQUERY_URL = "yc.jyxx.mjg.ztquery.url";


    /**
     * 交易备案信息申请新增/修改接口
     */
    public static final String JYXX_BAXX_BASQ_URL = "yc.jyxx.baxx.basq.url";

    /**
     * 交易备案信息申请新增/修改接口
     */
    public static final String JYXX_BAXX_BAZTQUERY_URL = "yc.jyxx.baxx.baztquery.url";


    /**
     * 昆山合同资金状态信息获取
     */
    public static final String JYXX_BAXX_ZJZT_URL = "yc.jyxx.baxx.zjzt.url";

    /**
     * 交易备案信息获取接口
     */
    public static final String JYXX_BAXX_HQ_URL = "yc.jyxx.baxx.hq.url";

    /**
     * 交易系统token获取接口
     */
    public static final String JYXX_BAXX_TOKEN_URL = "yc.jyxx.baxx.token.url";
    /**
     * 网签备案电子合同信息获取接口
     */
    public static final String JYXX_BAXX_DZHTHQ_URL = "yc.jyxx_baxx_dzhthq_url";
    /**
     * 一卡清查询增量房核税--A001
     */
    public static final String YKQ_QUERY_ZLF_HS_URL = "yc.ykq.query.zlf.hs.url";
    /**
     * 一卡清查询存量房核税--A002
     */
    public static final String YKQ_QUERY_CLF_HS_URL = "yc.ykq.query.clf.hs.url";
    /**
     * 一卡清查询影像资料信息接收--A006
     */
    public static final String YKQ_QUERY_YXZL_JS_URL = "yc.ykq.query.yxzl.js.url";
    /**
     * 一卡清查询完税信息获取--A009
     */
    public static final String YKQ_QUERY_WSXX_HQ_URL = "yc.ykq.query.wsxx.hq.url";
    /**
     * 一卡清查询完税信息获取--A010
     */
    public static final String YKQ_QUERY_SBZT_HQ_URL = "yc.ykq.query.sbzt.hq.url";
    /**
     * 一卡清查询发票信息获取--A013
     */
    public static final String SW_HQ_DZFPXX_URL = "yc.sw.hqdzfpxx.url";
    /**
     * 一卡清查询获取申报信息--A014
     */
    public static final String YKQ_QUERY_SBXX_HQ_URL = "yc.ykq.query.sbxx.hq.url";
    /**
     * 一卡清查询确认申报信息--A015
     */
    public static final String YKQ_QUERY_SBXX_QR_URL = "yc.ykq.query.sbxx.qr.url";
    /**
     * 一卡清查询获取待缴款信息--A017
     */
    public static final String YKQ_QUERY_DJKXX_HQ_URL = "yc.ykq.query.djkxx.hq.url";
    /**
     * 一卡清查询获取缴款二维码--A018
     */
    public static final String YKQ_QUERY_JKEWM_HQ_URL = "yc.ykq.query.jkewm.hq.url";
    /**
     * 一卡清查询缴款结果查询--A019
     */
    public static final String YKQ_QUERY_JKJG_URL = "yc.ykq.query.jkjg.url";
    /**
     * 一卡清查询契税完税凭证获取--A020
     */
    public static final String YKQ_QUERY_QSWSPZ_HQ_URL = "yc.ykq.query.qswspz.hq.url";
    /**
     * 一卡清查询契税联系单获取--A021
     */
    public static final String YKQ_QUERY_QSLXD_HQ_URL = "yc.ykq.query.qslxd.hq.url";
    /**
     * 一卡清查询获取税费同缴缴款信息--A022
     */
    public static final String YKQ_QUERY_SFTJ_JKXX_HQ_URL = "yc.ykq.query.sftj.jkxx.hq.url";
    /**
     * 一卡清查询房产交易申报--A023
     */
    public static final String YKQ_QUERY_FCJYSB_URL = "yc.ykq.query.fcjysb.url";
    /**
     * 一卡清生成订单
     */
    public static final String YKQ_SCDD_URL = "yc.ykq.scdd.url";
    /**
     * 一卡清生成订单v3
     */
    public static final String YKQ_SCDD_V3_URL = "yc.ykq.scdd.v3.url";
    /**
     * 一卡清查询订单
     */
    public static final String YKQ_CXDD_URL = "yc.ykq.cxdd.url";
    /**
     * 一卡清推送缴库
     */
    public static final String YKQ_TSJK_URL = "yc.ykq.tsjk.url";
    /**
     * 一卡清查询订单v2
     */
    public static final String YKQ_CXDD_V2_URL = "yc.ykq.cxdd.v2.url";
    /**
     * 获取电子发票明细
     */
    public static final String YKQ_QUERY_DZFPMX_HQ_URL = "yc.ykq.query.dzfpmx.hq.url";
    /**
     * 查询（第三方登记申请）产权证的抵押信息接口
     */
    public static final String WWSQ_QUERY_DYAQXX_URL = "yc.wwsq.query.dyaqxx.url";
    /**
     * 安徽省税务--增量房采集
     */
    public static final String SWXT_FIRSTHOUSEINFO_URL = "yc.swxt.firsthouseinfo.url";
    /**
     * 安徽省税务--存量房采集
     */
    public static final String SWXT_SECONDHOUSEINFO_URL = "yc.swxt.secondhouseinfo.url";
    /**
     * 安徽省税务--土地采集
     */
    public static final String SWXT_LANDTRANSFERINFO_URL = "yc.swxt.landtransferinfo.url";
    /**
     * 安徽省税务--附件上传
     */
    public static final String SWXT_PICTUREUPLOAD_URL = "yc.swxt.pictureUpload.url";
    /**
     * 安徽省税务--税款明细查询
     */
    public static final String SWXT_TAXDETAILS_URL = "yc.swxt.taxDetails.url";
    /**
     * 安徽省税务--获取电子税票信息接口（完税凭证）
     */
    public static final String SWXT_TAXRECEIPT_URL = "yc.swxt.taxReceipt.url";
    /**
     * 安徽省税务--作废取消
     */
    public static final String SWXT_CANCELS_URL = "yc.swxt.cancels.url";
    /**
     * 安徽省税务--获取三要素
     */
    public static final String SWXT_UNIONPAY_URL = "yc.swxt.unionpay.url";
    /**
     * 安徽物业处获取维修基金地址
     */
    public static final String WXJJ_KH_URL = "yc.wxjj.kh.url";
    /**
     * 安徽维修基金不缴存通知地址
     */
    public static final String WXJJ_BJCTZ_URL = "yc.wxjj.bjctz.url";
    /**
     * 安徽物业处获取维修基金缴费状态地址
     */
    public static final String WYC_WXJJ_CXJFZT_URL = "yc.wyc.wxjj.cxjfzt.url";


    /**
     * 昆山税务获取支付连接地址
     */
    public static final String KS_SW_HQZFLJ_URL = "yc.ks.sw.hqzflj.url";
    /**
     * 昆山税务推送附件地址
     */
    public static final String KS_SW_TSFJ_URL = "yc.ks.sw.tsfj.url";
    /**
     * 昆山税务查询获取税款信息
     */
    public static final String KS_SW_HQSKXX_URL = "yc.ks.sw.hqskxx.url";
    /**
     * 昆山核税
     */
    public static final String KS_SW_HS_URL = "yc.ks.sw.hs.url";
    /**
     * 昆山获取申报信息
     */
    public static final String KS_SW_HQSBXX_URL = "yc.ks.sw.hqsbxx.url";
    /**
     * 昆山核税
     */
    public static final String KS_SW_QRSBXX_URL = "yc.ks.sw.qrsbxx.url";
    /**
     * 昆山查询完税凭证
     */
    public static final String KS_SW_QUERY_WSPZ_URL = "yc.ks.sw.query.wspz.url";
    /**
     * 昆山查询完税凭证类型
     */
    public static final String KS_SW_QUERY_WSPZLX_URL = "yc.ks.sw.query.wspzlx.url";
    /**
     * 昆山税务转开房产交易完税凭证
     */
    public static final String KS_SW_QUERY_DZSP_URL = "yc.ks.sw.query.dzsp.url";
    /**
     * 昆山税务查询电子发票
     */
    public static final String KS_SW_QUERY_DZFP_URL = "yc.ks.sw.query.dzfp.url";
    /**
     * 昆山税务查询三要素
     */
    public static final String KS_SW_QUERY_SYS_URL = "yc.ks.sw.query.sys.url";
    /**
     * 昆山查询契税联系单
     */
    public static final String KS_SW_QUERY_QSLXD_URL = "yc.ks.sw.query.qslxd.url";
    /**
     * 昆山查询契税联系单1.1
     */
    public static final String KS_SW_QUERY_QSLXDV1_URL = "yc.ks.sw.query.qslxdv1.url";

    /**
     * 外网申请推送附件地址（大云附件）
     */
    public static final String YC_WWSQ_TS_FJXX_UPLOAD_URL = "yc.wwsq.ts.fjxx.upload.url";
    /**
     * 大华视频监控地址--创建会话第一次请求
     */
    public static final String DAHUA_VIDEO_FIRST = "yc.video.first.url";
    /**
     * 大华视频监控地址--创建会话第二次请求
     */
    public static final String DAHUA_VIDEO_SECOND = "yc.video.second.url";
    /**
     * 大华视频监控地址--获取视频流
     */
    public static final String DAHUA_VIDEO_MONITOR = "yc.video.monitor.url";

    /**
     * 水电气--查询燃气是否能过户
     */
    public static final String SDQ_QI_SFNGH_URL = "yc.sdq.qi.sfngh.url";
    /**
     * 水电气--查询水费信息
     */
    public static final String SDQ_SHUI_QUERFY_URL = "yc.sdq.shui.queryfy.url";
    /**
     * 水电气--查询电费信息
     */
    public static final String SDQ_DIAN_QUERYFY_URL = "yc.sdq.dian.queryfy.url";
    /**
     * 水电气--查询电客户基本信息
     */
    public static final String SDQ_DIAN_USER_DETAIL_URL = "yc.sdq.dian.user.detail.url";
    /**
     * 水电气--提交电费过户申请
     */
    public static final String SDQ_DIAN_GH_COMMIT_URL = "yc.sdq.dian.gh.commit.url";
    /**
     * 水电气--提交水过户申请
     */
    public static final String SDQ_SHUI_GH_COMMIT_URL = "yc.sdq.shui.gh.commit.url";
    /**
     * 水电气--提交燃气过户申请
     */
    public static final String SDQ_QI_GH_COMMIT_URL = "yc.sdq.qi.gh.commit.url";
    /**
     * 水电气--查询电过户结果
     */
    public static final String SDQ_DIAN_GH_RESULT_URL = "yc.sdq.dian.gh.result.url";
    /**
     * 水电气--查询水电气过户结果
     */
    public static final String SDQ_GH_RESULT_URL = "yc.sdq.gh.result.url";

    /**
     * 第三方附件(昆山共享交互平台)下载
     */
    public static final String WWSQ_FJ_THIRD_DOWNLOAD_URL = "yc.wwsq.fj.third.download.url";
    /**
     * 第三方附件(户室图)下载
     */
    public static final String WWSQ_FJ_THIRD_HST_DOWNLOAD_URL = "yc.wwsq.fj.third.hst.download.url";
    /**
     * 第三方附件(宗地图)下载
     */
    public static final String WWSQ_FJ_THIRD_ZDT_DOWNLOAD_URL = "yc.wwsq.fj.third.zdt.download.url";
    /**
     * 第三方附件(云签视频双录文件)下载
     */
    public static final String WWSQ_FJ_THIRD_SIGN_SPSL_DOWNLOAD_URL = "yc.wwsq.fj.third.sign.spsl.download.url";
    /**
     * 第三方附件(房管系统合同附件)下载
     */
    public static final String WWSQ_FJ_THIRD_FGXT_HTXX_URL = "yc.wwsq.fj.third.fgxt.htxx.url";
    /**
     * 第三方附件(登记附件)下载
     */
    public static final String WWSQ_FJ_THIRD_DJ_DOWNLOAD_URL = "yc.wwsq.fj.third.dj.download.url";
    /**
     * 第三方附件(交易电子合同)下载
     */
    public static final String WWSQ_FJ_THIRD_JY_DZHT_DOWNLOAD_URL = "yc.wwsq.fj.third.jy.dzht.download.url";
    /**
     * 第三方附件(房屋套次pdf)下载
     */
    public static final String WWSQ_FJ_THIRD_FWTC_URL = "yc.wwsq.fj.third.fwtc.url";
    /**
     * 第三方附件(登记登记簿查询pdf接口)下载
     */
    public static final String WWSQ_FJ_THIRD_DAXX_URL = "yc.wwsq.fj.third.daxx.url";
    /**
     * /**
     * 第三方附件(通过坐落查询不动产登记簿pdf)下载
     */
    public static final String WWSQ_FJ_THIRD_DJB_BYZL_URL = "yc.wwsq.fj.third.djb.byzl.url";
    /**
     * 不动产登记信息查询(利害关系人查询PDF下载)
     */
    public static final String YC_WWSQ_FJ_THIRD_LHGXRCX_URL = "yc.wwsq.fj.third.lhgxrcx.url";
    /**
     * 税务附件下载
     */
    public static final String YC_WWSQ_FJ_THIRD_SW_URL = "yc.wwsq.fj.third.sw.url";
    /**
     * 完税凭证附件下载
     */
    public static final String YC_WWSQ_FJ_THIRD_WSPZ_URL = "yc.wwsq.fj.third.wspz.url";
    /**
     * /**
     * 第三方附件(江苏政务 获取身份证电子证照)下载
     */
    public static final String JSSZW_DZZZXX_URL = "yc.jsszw.dzzzxx.url";
    /**
     * /**
     * 第三方附件(江苏政务 获取身份证电子证照)信息获取接口（下载接口需要先调用该接口获取入参）
     */
    public static final String JSSZW_DZZZXX_XXHQ_URL = "yc.jsszw.dzzzxx.xxhq.url";
    /**
     * 电子证照线上请求授权
     */
    public static final String WWSQ_DZZZ_ONLINE_AUTH_URL = "yc.wwsq.dzzz.online.auth.url";
    /**
     * 电子证照下载证照材料文件
     */
    public static final String WWSQ_DZZZ_DOWNLOAD_FILE_URL = "yc.wwsq.dzzz.download.file.url";
    /**
     * 电子证照验证人脸token
     */
    public static final String WWSQ_DZZZ_CHECK_TOKEN_URL = "yc.wwsq.dzzz.check.token.url";
    /**
     * 电子证照信息查询下载
     */
    public static final String WWSQ_DZZZ_ZZXX_QUERY_DOWNLOAD_URL = "yc.wwsq.dzzz.zzxx.query.download.url";
    /**
     * 登记电子证照预览
     */
    public static final String WWSQ_DZZZ_QUERY_URL = "yc.wwsq.dzzz.query.url";
    /**
     * 登记电子证照检索
     */
    public static final String WWSQ_DZZZ_JS_URL = "yc.wwsq.dzzz.js.url";
    /**
     * 登记电子证照下载
     */
    public static final String WWSQ_DZZZ_DOWNLOAD_URL = "yc.wwsq.dzzz.download.url";
    /**
     * 登记批量获取电子证照压缩包
     */
    public static final String WWSQ_DZZZ_MUL_DOWNLOAD_URL = "yc.wwsq.mul.dzzz.download.url";

    /**
     * 三要素信息比对
     */
    public static final String ESIGN_SYSXXBD_URL = "yc.esign.sysxxbd.url";

    /**
     * 单点登录
     * 镇江政务网获取token
     */
    public static final String YC_ZJZWW_SSO_LOGIN_GETTOKEN_URL = "yc.zjzww.sso.getToken.url";

    /**
     * 镇江政务网获取用户信息
     */
    public static final String YC_ZJZWW_SSO_LOGIN_GETUERT_URL = "yc.zjzww.sso.getUser.url";

    /**
     * 镇江政务网获取企业信息
     */
    public static final String YC_ZJZWW_SSO_LOGIN_GETORG_URL = "yc.zjzww.sso.getOrg.url";

    /**
     * 前端地址
     */
    public static final String REGISTER_UI_URL = "register.ui.url";

    /**
     * 节假日.工作日
     */
    public static final String YYXX_HQJJR_HQGGR_URL = "yyxx.hqjjr.hqggr.url";

    /**
     * 获取合同附件地址
     */
    public static final String YC_HTXX_GETFILE_URL = "yc.htxx.getFile.url";
    /**
     * 按不动产权证书中文号（原）简称/全称查询带押过户登记申请
     */
    public static final String YC_QUERY_DYGH_URL = "yc.query.dygh.url";
    /**
     * 查询住房历史信息
     */
    public static final String YC_QUERY_ZFLSXX_URL = "yc.query.zflsxx.url";
    /**
     * 查询房屋登记历史
     */
    public static final String YC_QUERY_FWDJ_LS_URL = "yc.query.fwdj.ls.url";
    /**
     * 调用登记C包实现ftp上传
     */
    public static final String WWWSQ_TS_GETCURRENYFTPURL_URL = "yc.wwsq.ts.getcurrenyftpurl.url";
    /**
     * 常州住建合同附件下载
     */
    public static final String YC_CZ_ZJBHT_URL = "yc.cz.zjbht.url";
    /**
     * 4.3.14	获取权利人和义务人（多个）
     */
    public static final String YC_PUBLIC_QUERY_QLRANDYWRLIST = "yc.public.query.qlrAndYwrList";
    /**
     * 4.3.16	获取抵押权权利状态及其产权状态
     */
    public static final String YC_PUBLIC_QUERY_QLZTLIST = "yc.public.query.qlztList";
    /**
     * 银行贷前查询
     */
    public static final String YC_BANK_DQCX_URL = "yc.bank.dqcx.url";
    /**
     * 银行贷后查询
     */
    public static final String YC_BANK_DHCX_URL = "yc.bank.dhcx.url";
    /**
     * e签宝 获取个人核身认证url
     */
    public static final String ESIGN_QUERY_VERIFY_URL = "yc.esign.query.verify.url";
    /**
     * e签宝 获取个人核身认证结果
     */
    public static final String ESIGN_QUERY_VERIFY_RESULT_URL = "yc.esign.query.verify.result.url";
    /**
     * 住建资金监管信息查询接口
     */
    public static final String WWSQ_QUERY_ZJJGXX_URL = "yc.wwsq.query.zjjgxx.url";
    /**
     * 视频办-获取人员信息url
     */
    public static final String WWSQ_QUERY_SPRYXX_URL = "yc.wwsq.query.spryxx.url";
    /**
     * 视频办-受理编号接收
     */
    public static final String WWSQ_QUERY_SLBHJS_URL = "yc.wwsq.query.slbhjs.url";
    /**
     * 视频办-附记目录接收
     */
    public static final String WWSQ_QUERY_FJMLJS_URL = "yc.wwsq.query.fjmljs.url";
    /**
     * 视频办-缴费信息接收
     */
    public static final String WWSQ_QUERY_JFXXJS_URL = "yc.wwsq.query.jfxxjs.url";

    /**
     * 摩科发起投屏地址
     */
    public static final String MK_FQTP_URL = "mk.fqtp.url";

    /**
     * 根据证照标识查询电子证照
     */
    public static final String WWSQ_QUERY_DZZZ_BYZZBS_URL = "yc.wwsq.query.dzzz.byzzbs.url";
    /**
     * 查询电子证照
     */
    public static final String WWSQ_DZZZ_CXZS_URL = "yc.wwsq.dzzz.cxzs.url";
    /**
     * ocr验证
     */
    public static final String OCR_CHECK_URL = "yc.ocr.check.url";

    /**
     * 昆山下载电子信息表
     */
    public static final String WWSQ_DOWN_DZXXB_URL = "yc.wwsq.down.dzxxb.url";
    /**
     * 查询申请状态
     */
    public static final String WWSQ_QUERY_SQZT_URL = "yc.wwsq.query.sqzt.url";

    /**
     * 安徽政务服务网-认证服务
     */
    public static final String YC_UCCP_SERVICE_URL = "yc.uccp.service.url";

    /**
     * 登记有房无房证明pdf查询接口
     */
    public static final String WWSQ_QUERY_YFWY_PDF_URL = "yc.wwsq.query.yfwf.pdf.url";
    /**
     * 登记未成年子女有房无房证明pdf查询接口
     */
    public static final String WWSQ_QUERY_WCNZN_YFWY_PDF_URL = "yc.wwsq.query.wcnzn.yfwf.pdf.url";
    /**
     * 登记权属证明pdf查询接口
     */
    public static final String WWSQ_QUERY_QSZM_PDF_URL = "yc.wwsq.query.qszm.pdf.url";

    /**
     * 登记灭失证明pdf查询接口
     */
    public static final String WWSQ_QUERY_MSZM_PDF_URL = "yc.wwsq.query.mszm.pdf.url";

    /**
     * 登记灭失信息查询接口
     */
    public static final String WWSQ_QUERY_MSXX_URL = "yc.wwsq.query.msxx.url";

    /**
     * 登记申请书查档证明查询接口
     */
    public static final String WWSQ_QUERY_SQSCDZM_PDF_URL = "yc.wwsq.query.sqscdzm.pdf.url";

    /**
     * 获取人脸识别认证令牌
     */
    public static final String GETFACETOKEN_URL = "yc.getFaceToken.url";
    /**
     * 核验实时状态查询
     */
    public static final String GETRESULT_URL = "yc.getResult.url";
    /**
     * 验证认证信息
     */
    public static final String ACCESSCHECK_URL = "yc.accessCheck.url";
    /**
     * 人脸识别结果通知
     */
    public static final String RLSBJGTZ_URL = "yc.wwsq.rlsbjgtz.url";
    /**
     * 税务退款接口
     */
    public static final String YC_SW_TK_V2_URL = "yc.sw.tk.v2.url";
    /**
     * 查询退款状态
     */
    public static final String YC_SW_CXTKZT_V2_URL = "yc.sw.cxtkzt.v2.url";

    /**
     * 一卡清生成非税缴款码
     */
    public static final String YKQ_HQFSJKM_URL = "yc.ykq.hqfsjkm.url";

    /**
     * 登记3.0订单状态推送地址
     */
    public static final String YC_DJ3_DDZTTS_URL = "yc.dj3.ddztts.url";

    /**
     * 一卡清订单信息查询地址
     */
    public static final String YC_YKQ_DDXXCX_URL = "yc.ykq.ddxxcx.url";
    /**
     * 查询税务完税凭证信息列表
     */
    public static final String YC_WWSQ_WSXX_URL = "yc.wwsq.wsxx.url";
    /**
     * 查询订单信息
     */
    public static final String YC_SW_CXDDXX_V2_URL = "yc.sw.cxddxx.v2.url";

    /**
     * 第三方附件(登记身份证信息查询接口)下载
     */
    public static final String WWSQ_FJ_THIRD_JMSFZ_URL = "yc.wwsq.fj.third.jmsfz.url";

    /**
     * 获取大数据局access_token接口
     */
    public static final String WWSQ_DSJJ_ACCESSTOKEN_URL = "yc.wwsq.dsjj.accesstoken.url";

    /**
     * 获取大数据局安全回话接口
     */
    public static final String WWSQ_DSJJ_AQHH_URL = "yc.wwsq.dsjj.aqhh.url";
    /**
     * 第三方附件(登记身份信息查询接口)查询
     */
    public static final String WWSQ_FJ_THIRD_JMSFXX_URL = "yc.wwsq.fj.third.jmsfxx.url";

    /**
     * 微信-发送模板消息
     */
    public static final String YC_WX_TEMPLATE_MESSAGE_URL = "yc.wx.template.message.url";

    /**
     * 微信-用户授权地址
     */
    public static final String YC_WX_AUTH_URL = "yc.wx.auth.url";

    /**
     * 微信-获取openid
     */
    public static final String YC_WX_GET_OPENID_URL = "yc.wx.get.openid.url";

    /**
     * 一窗查询第三方用户信息地址
     */
    public static final String YC_THIRD_USERINFO_QUERY_URL = "yc.third.userinfo.query.url";

    /**
     * 一窗根据ticket获取江苏政务token地址
     */
    public static final String YC_JSZW_TOKENBYTICKET_URL = "yc.jszw.tokenbyticket.url";
    /**
     * 接口4.2：登记系统发起评价功能接口（上传省厅接口版）
     */
    public static final String YC_MK_FQPJ_URL = "yc.mk.fqpj.url";
    /**
     * 接口14：登记系统发起读取身份证功能
     */
    public static final String YC_MK_FQDQSFZ_URL = "yc.mk.fqdqsfz.url";
    /**
     * 接口15：登记系统获取身份证信息接口
     */
    public static final String YC_MK_HQSFZXX_URL = "yc.mk.hqsfzxx.url";
    /**
     * 接口16：登记系统发起高拍仪接口
     */
    public static final String YC_MK_FQGPY_URL = "yc.mk.fqgpy.url";
    /**
     * 接口17：登记系统获取高拍仪拍照图片接口
     */
    public static final String YC_MK_HQGPYTP_URL = "yc.mk.hqgpytp.url";
    /**
     * 江苏政务服务单点登录
     */
    public static final String YC_JSZWFW_SSO_LOGIN_URL = "yc.jszwfw.sso.login.url";
    /**
     * 分页查询预告预抵押
     */
    public static final String YC_QUERY_YGXX_PAGE_URL = "yc.query.ygxx.page.url";
    //登记接口，请按顺序放最上面，谢谢！
}
