package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyFjYq;

import java.util.List;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/7/12
 * @description (GxYyFjYq)表数据库访问层
 */
public interface GxYyFjYqRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param qsrwid 主键
     * @return 实例对象
     */
    GxYyFjYq get(String qsrwid);

    /**
     * 通过ID查询ji数据
     *
     * @param qsrwid 主键
     * @return 实例对象
     */
    List<GxYyFjYq> list(String qsrwid);

    /**
     * 新增数据
     *
     * @param gxYyFjYq 实例对象
     * @return 影响行数
     */
    void save(GxYyFjYq gxYyFjYq);

    /**
     * 新增数据
     *
     * @param gxYyFjYq 实例对象
     * @return 影响行数
     */
    void saveOrUpdate(GxYyFjYq gxYyFjYq);

    /**
     * 新增数据
     *
     * @param gxYyFjYqList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYyFjYq> gxYyFjYqList);

    /**
     * 修改数据
     *
     * @param gxYyFjYq 实例对象
     * @return 影响行数
     */
    void update(GxYyFjYq gxYyFjYq);

    /**
     * 批量更新
     *
     * @param gxYyFjYqList 实例对象
     */
    void updateBatch(List<GxYyFjYq> gxYyFjYqList);

    /**
     * 通过slbh查询单条数据
     *
     * @param slbh 受理编号
     * @return 实例对象
     */
    List<GxYyFjYq> getBySlbh(String slbh);

    /**
     * 通过证件号查询未签署完成的云签附件数据
     *
     * @param qlrzjh 权利人证件号
     * @return 实例对象
     */
    List<GxYyFjYq> getByQlrzjh(String qlrzjh);

    /**
     * 通过sqid查询单条数据
     *
     * @param sqid 申请id
     * @return 实例对象
     */
    GxYyFjYq getBySqid(String sqid);

    /**
     * 通过受理编号和签署类型获取已签署的云签集合
     *
     * @param slbh 受理编号
     * @param qslx 签署类型
     * @return 实例对象
     */
    List<GxYyFjYq> getYqsYqxx(String slbh, String qslx);

    /**
     * 通过权利人信息和sqid获取附件云签
     *
     * @param qlrmc 权利人名称
     * @param qlrzjh 权利人证件号
     * @param sqid 申请id
     * @return 实例对象
     */
    List<GxYyFjYq> getBySqidAndQlr(String qlrmc, String qlrzjh, String sqid);

    /**
     * 通过流水号获取附件云签信息
     *
     * @param lsh 流水号
     * @return 实例对象
     */
    List<GxYyFjYq> getByLsh(String lsh);

    /**
     * 获取签署文件
     * @param qsrwid
     * @param lsh
     * @return
     */
    List<GxYyFjYq> getFjYqListOr(String qsrwid, String lsh);

    /**
     * 获取签署文件
     * @param slbh
     * @return
     */
    List<GxYyFjYq> getListBySlbh(String slbh);

    /**
     * 通过附件id和签署任务id查询
     *
     * @param qsrwid 签署任务id
     * @param fjid 附件id
     * @param qlrzjh 权利人证件号
     * @return 实例对象
     */
    GxYyFjYq getByQsrwidAndFjidAndQlrzjh(String qsrwid, String fjid, String qlrzjh);

    /**
     * 通过主键删除数据
     * @param yqid 云签id
     * @return
     */
    void deleteById(String yqid);
}

