package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 我的信箱(GxYyWdxx)表实体类BO
 *
 * @author makejava
 * @since 2023-07-06 15:54:16
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyWdxx implements Serializable {
    private static final long serialVersionUID = 7653506172159086142L;
    /**我的邮箱表id*/
    private String id;

    /**信息类型（关联信息字典表）*/
    private String xxlx;

    /** 创建人（user表guid）*/
    private String cjr;

    /**接收人（user信息表guid）*/
    private String jsr;

    /**业务号（推送时可将推送业务的业务号送过来，关联到该业务）*/
    private String ywh;

    /**标题 */
    private String bt;

    /**副标题*/
    private String fbt;

    /**内容*/
    private String nr;

    /**是否已读（0：未读，1已读）*/
    private String sfyd;

    /**创建时间*/
    private Date cjsj;

    /**阅读时间*/
    private Date ydsj;

    /**业务类型（1:申请信息,2:预约信息,3:人脸验证信息）*/
    private String ywlx;
    /**
     * 总数
     */
    private Integer count;
}

