/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfSigner {
    private static final Logger log = LoggerFactory.getLogger(PdfSigner.class);

    public static byte[] addSignatureToPdf(File inputPdfFile, String base64Image, Float x, Float y) throws IOException {
        String pureBase64 = base64Image.contains(",") ? base64Image.split(",")[1] : base64Image;
        try (PDDocument document = PDDocument.load((File)inputPdfFile);){
            Object object;
            byte[] imageBytes = Base64.getDecoder().decode(pureBase64);
            PDImageXObject image = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])imageBytes, (String)"signature");
            int pageIndex = document.getNumberOfPages() - 1;
            PDPage page = document.getPage(pageIndex);
            float margin = 20.0f;
            float imgWidth = 40.0f;
            float imgHeight = imgWidth / (float)image.getWidth() * (float)image.getHeight();
            float pageWidth = page.getMediaBox().getWidth();
            if (x == null) {
                x = Float.valueOf(pageWidth - imgWidth - margin);
            }
            if (y == null) {
                y = Float.valueOf(margin);
            }
            try {
                PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
                object = null;
                try {
                    contentStream.drawImage(image, x.floatValue(), y.floatValue(), imgWidth, imgHeight);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (contentStream != null) {
                        if (object != null) {
                            try {
                                contentStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            contentStream.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.info("\u7b7e\u540d\u5408\u5e76\u5f02\u5e38", (Throwable)e);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            document.save((OutputStream)outputStream);
            object = outputStream.toByteArray();
            return object;
        }
    }
}

