package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYySqxxBgQlr;

import java.util.List;

/**
 * 变更信息（前）权利人表(GxYySqxxBgQlr)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:46
 */
public interface GxYySqxxBgQlrRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param qlrid 主键
     * @return 实例对象
     */
    GxYySqxxBgQlr get(String qlrid);

    /**
     * 新增数据
     *
     * @param gxYySqxxBgQlr 实例对象
     * @return 影响行数
     */
    void save(GxYySqxxBgQlr gxYySqxxBgQlr);

    /**
     * 新增数据
     *
     * @param gxYySqxxBgQlrList 实例对象
     * @return 影响行数
     */
    void saveOrUpdateBatch(List<GxYySqxxBgQlr> gxYySqxxBgQlrList);

    /**
     * 修改数据
     *
     * @param gxYySqxxBgQlr 实例对象
     * @return 影响行数
     */
    void update(GxYySqxxBgQlr gxYySqxxBgQlr);

    /**
     * 通过sqidList查询集合数据
     *
     * @param sqidList
     * @return 实例对象
     */
    List<GxYySqxxBgQlr> list(List<String> sqidList);

    /**
     * 通过qlridList删除集合数据
     *
     * @param qlridList
     * @return 实例对象
     */
    int deleteBatchIds(List<String> qlridList);

    /**
     * 通过sqidList删除集合数据
     *
     * @param sqidList
     * @return 影响行数
     */
    int deleteBySqidList(List<String> sqidList);
    /**
     * 根据sqid删除
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void deleteBySqid(String sqid);
    /**
     * 根据sqid查询
     * @param sqid
     * @return:cn.gtmap.hlw.domain.sqxx.model.GxYySqxxBgQlr
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYySqxxBgQlr> getBySqid(String sqid);
}

