package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/1/2
 * @description
 */
@Getter
@AllArgsConstructor
public enum TkztEnum {
    /**
     * 未退款
     */
    TKZT_WTK("0", "未退款"),
    /**
     * 退款中
     */
    TKZT_TKZ("0", "退款中"),
    /**
     * 退款成功
     */
    TKZT_TKCG("0", "退款成功"),
    /**
     * 退款失败
     */
    TKZT_TKSB("0", "退款失败"),
    /**
     * 无法完成退款
     */
    TKZT_WFWCTK("0", "无法完成退款");

    @Getter
    private String code;

    @Getter
    private String mc;

    public static String getMc(String code) {
        for (TkztEnum xq : TkztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMc();
            }
        }
        return null;
    }
}
