package cn.gtmap.hlw.core.dto.third.cqxx;

import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/8 13:48
 * @description ThirdHtxxQueryDTO
 */
@Data
public class CqxxThirdQueryDTO {
    /**
     * 步骤id
     */
    private String processId;

    /**
     * 权利人名称
     */
    private String qlrmc;
    /**
     * 开发商权利人名称
     */
    private String kfsqlrmc;

    /**
     * 权利人证件号
     */
    private String qlrzjh;
    /**
     * 权利人名称(模糊)
     */
    private String qlrmcmh;
    /**
     * 权利人证件号(模糊)
     */
    private String qlrzjhmh;

    /**
     * 区域代码
     */
    private String qydm;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 产权证号模糊
     */
    private String cqzhmh;
    /**
     * 产权证号简称
     */
    private String cqzhjc;


    /**
     * 坐落
     */
    private String zl;

    /**
     * 坐落精确
     */
    private String zljq;

    /**
     * 查询类型 1存量房买卖，0商品房证明
     */
    private String cxlx;

    /**
     * 申请类型 --前端传
     */
    private String sqlx;

    /**
     * 项目id
     */
    private String xmid;

    /**
     * 项目id集合
     */
    private List<String> xmidList;

    /**
     * bdcdyh
     */
    private String bdcdyh;
    /**
     * 不动产单元编号精确
     */
    private String bdcdyhjq;

    private String bdclx;

    /**
     * 不动产单元编号
     */
    private String bdcdybh;
    /**
     * 登记slbh
     */
    private String djslbh;
    /**
     * 合同编号
     */
    private String htbh;
    /**
     * 合同编号
     */
    private String mmhth;
    /**
     * 校验权利人名称
     */
    private String validqlrmc;

    /**
     * 校验权利人证件号
     */
    private String validqlrzjh;

    /**
     * 房屋编号类型
     */
    private String fwbhlx;

    /**
     * 关系人类型
     */
    private String gxrlx;
    /**
     * 房屋代码
     */
    private String fwdm;
    /**
     * 权籍关联代码
     */
    private String qjgldm;
    /**
     * 住建转移受理编号
     */
    private String zjzyslbh;

    /**
     * roomid
     */
    private String roomid;

    /**
     * 关系人名称
     */
    private String gxrmc;

    /**
     * 关系人证件号
     */
    private String gxrzjh;
}
