/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.hlw.core.util.encryption;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.symmetric.SM4;

public class CryptoUtils {
    public static String sm2Decrypt(String text, String privateKey) {
        return StrUtil.utf8Str((Object)SmUtil.sm2((String)privateKey, null).decryptFromBcd(text, KeyType.PrivateKey));
    }

    public static String sm4Encrypt(String text, String key) {
        return CryptoUtils.sm4Encrypt(text, key, "", "ECB", Padding.PKCS5Padding.name());
    }

    public static String sm4Encrypt(String text, String key, String iv, String mode, String padding) {
        return new SM4(mode, padding, CryptoUtils.getKey(key), iv.getBytes(CharsetUtil.CHARSET_UTF_8)).encryptHex(text);
    }

    public static String sm4EncryptBase64(String text, String key, String iv, String mode, String padding) {
        return new SM4(mode, padding, CryptoUtils.getKey(key), iv.getBytes(CharsetUtil.CHARSET_UTF_8)).encryptBase64(text);
    }

    private static byte[] getKey(String key) {
        if (key.length() == 32) {
            return HexUtil.decodeHex((String)key);
        }
        if (key.length() == 16) {
            return key.getBytes();
        }
        return null;
    }

    public static String sm4Decrypt(String text, String key) {
        return CryptoUtils.sm4Decrypt(text, key, "", "ECB", Padding.PKCS5Padding.name());
    }

    public static String sm4Decrypt(String text, String key, String iv, String mode, String padding) {
        return new SM4(mode, padding, CryptoUtils.getKey(key), iv.getBytes(CharsetUtil.CHARSET_UTF_8)).decryptStr(text);
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte aByte : bytes) {
            String temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                stringBuilder.append("0");
            }
            stringBuilder.append(temp);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) {
    }
}

