package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyJtcy;

import java.util.List;

/**
 * (GxYyJtcy)表数据库访问层
 *
 * @author makejava
 * @since 2023-05-31 14:14:49
 */
public interface GxYyJtcyRepository {
    /**
     * 通过ID查询单条数据
     *
     * @param jtcyid 主键
     * @return 实例对象
     */
    GxYyJtcy get(Integer jtcyid);

    /**
     * 新增数据
     *
     * @param GxYyJtcy 实例对象
     * @return 影响行数
     */
    void save(GxYyJtcy GxYyJtcy);
    /**
     * 修改数据
     *
     * @param GxYyJtcy 实例对象
     * @return 影响行数
     */
    void update(GxYyJtcy GxYyJtcy);
    /**
     * 通过申请ID查询家庭成员信息集合
     *
     * @param sqid 申请ID
     * @return 实例对象
     */
    List<GxYyJtcy> list(String sqid);
    
    /**
     * 通过ID删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int delete(Integer id);
    
    /**
     * 批量保存
     * @param jtcyList
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void saveBatch(List<GxYyJtcy> jtcyList);
    /**
     * 根据证件号查询
     * @param sqid
     * @param qlrzjh
     * @return:cn.gtmap.hlw.domain.sqxx.model.GxYyJtcy
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    GxYyJtcy getByZjh(String sqid,String qlrzjh);
    /**
     * 根据sqid删除
     * @param sqid
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    void delBySqid(String sqid);
    /**
     * 根据家庭名称查询
     * @param sqid
     * @param jtmc
     * @return:java.util.List<cn.gtmap.hlw.domain.sqxx.model.GxYyJtcy>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyJtcy> list(String sqid, String jtmc);
    /**
     * 根据sqid集合查询
     * @param sqidList
     * @return:java.util.List<cn.gtmap.hlw.domain.sqxx.model.GxYyJtcy>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyJtcy> list(List<String> sqidList);
}

