package cn.gtmap.hlw.core.po;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2024/5/30
 * 打印主表配置表
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@TableName("gx_yy_dysj_pz")
public class GxYyDysjPzPO extends Model<GxYyDysjPzPO> implements Serializable {

    @TableId("dyid")
    private String dyid;
    /**
     * 配置用途或者名称
     */
    private String ytmc;
    /**
     * 打印类型
     */
    private String dylx;
    /**
     * 参数
     */
    private String cs;
    /**
     * 打印数据源(加密SQL)
     */
    private String dysjy;
    /**
     * 打印字段（xml配置）
     */
    @ApiModelProperty(value = "打印字段")
    private String dyzd;
    /**
     * pdf打印模板地址
     */
    private String pdfpath;
    /**
     * 配置日期
     */
    private Date pzrq;
}
