package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 历史--过户信息-广电信息(HgxYySqxxGhxxGdxx)表实体类BO
 *
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @since 2023-08-09 17:17:45
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HgxYySqxxGhxxGdxx implements Serializable {
    private static final long serialVersionUID = 6646294410591743221L;
    /**
     * 主键
     */
    private String id;

    /**
     * 过户信息ID
     */
    private String ghxxid;

    /**
     * 受理类型
     */
    private String sllxdm;

    /**
     * 机顶盒序号1
     */
    private String jdhxhI;

    /**
     * 机顶盒序号2
     */
    private String jdhxhIi;

    /**
     * 机顶盒序号3
     */
    private String jdhxhIii;

    /**
     * 智能卡号1
     */
    private String znkhI;

    /**
     * 智能卡号2
     */
    private String znkhIi;

    /**
     * 智能卡号3
     */
    private String znkhIii;

    /**
     * 顺序号
     */
    private String sxh;

    /**
     * 广电是否欠费（0:否，不欠费，1:是 欠费）
     */
    private String gdsfqf;

    /**
     * 原广电户号（过户前）
     */
    private String ygdhh;

    /**
     * 广电户号（过户后）
     */
    private String gdhh;

    /**
     * 原广电户号户主（过户前gx_yy_qlr.qlrid）
     */
    private String ygdhhhzQlrid;

    /**
     * 广电户号户主（过户后gx_yy_qlr.qlrid）
     */
    private String gdhhhzQlrid;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 创建人员(gx_yy_user.USER_GUID)
     */
    private String createUser;

    /**
     * 修改人员(gx_yy_user.USER_GUID)
     */
    private String updateUser;

}

