package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/19
 * @description 税务状态
 */
@Getter
@AllArgsConstructor
public enum SwztEnum {
    /**
     * 申请信息税务状态-无需纳税
     */
    SWZT_WXNS("0", "无需纳税"),
    /**
     * 申请信息税务状态-未核税
     */
    SWZT_WHS("1", "未核税"),
    /**
     * 申请信息税务状态-已核税
     */
    SWZT_YHS("2", "已核税"),
    /**
     * 申请信息税务状态-已缴税
     */
    SWZT_YJS("3", "已缴税"),
    /**
     * 申请信息税务状态-未缴税
     */
    SWZT_WJS("4", "未缴税"),
    /**
     * 申请信息税务状态-缴税失败
     */
    SWZT_JSSB("5", "缴税失败"),
    /**
     * 申请信息税务状态-核税中
     */
    SWZT_HSZ("6", "核税中"),
    /**
     * 申请信息税务状态-核税失败
     */
    SWZT_HSSB("7", "核税失败"),
    /**
     * 申请信息税务状态-上报成功
     */
    SWZT_SBCG("8", "上报成功"),
    /**
     * 申报失败
     */
    SWZT_SBSB("9", "申报失败"),
    /**
     * 已作废
     */
    SWZT_YZF("10", "已作废"),
    /**
     * 部分缴税
     */
    SWZT_BFJS("11", "部分缴税"),
    /**
     * 部分缴税
     */
    SWZT_DSC("99", "待生成");

    @Getter
    private String code;

    @Getter
    private String mc;

    public static String getMc(String code) {
        for (SwztEnum xq : SwztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMc();
            }
        }
        return null;
    }
}
