package cn.gtmap.hlw.core.util.xml;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/10/21
 * @description
 */

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.symmetric.SymmetricCrypto;

public class Sm4util {

    /**
     * key必须是16字节，即128位
     */
    static final String KEY = "gtmapctf20231024";

    /**
     * 指明加密算法和秘钥
     */
    static SymmetricCrypto sm4 = new SymmetricCrypto("SM4/ECB/PKCS5Padding", KEY.getBytes());

    /**
     * 加密为16进制，也可以加密成base64/字节数组
     *
     * @param plaintext
     * @return
     */
    public static String encryptSm4(String plaintext) {
        if (StrUtil.isBlank(plaintext)) {
            return "";
        }
        return sm4.encryptHex(plaintext);
    }

    /**
     * 解密
     *
     * @param ciphertext
     * @return
     */
    public static String decryptSm4(String ciphertext) {
        if (StrUtil.isBlank(ciphertext)) {
            return "";
        }
        return sm4.decryptStr(ciphertext);
    }

    public static void main(String[] args) {
        String yhg275qw76ub62pv346estgp8dutzgwk = decryptSm4("AymqwRC7u88Y4JPvfIF2F37QKylC04248hLCdJAsh8xgOfe/dVJPV3XS3wLFca1ZMVOtnBfVjaCMTVudWM//5g4AAAB7eyJvcmlnaW4iOiJodHRwczovL3d3dy5nb29nbGV0YWdtYW5hZ2VyLmNvbTo0NDMiLCJmZWF0dXJlIjoiUHJpdmFjeVNhbmRib3hBZHNBUElzIiwiZXhwaXJ5IjoxNjk1MTY3OTk5LCJpc1RoaXJkUGFydHkiOnRydWV9");
//        String ps=decryptSm4("2186a96a84c3b4959a43c7e5b656b0fe");
        System.out.println("yhg275qw76ub62pv346estgp8dutzgwk = " + yhg275qw76ub62pv346estgp8dutzgwk);
//        System.out.println("ps = " + ps);
    }
}


