package cn.gtmap.hlw.core.model;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 不动产申请信息表(GxYySqxx)表实体类BO
 *
 * @author makejava
 * @since 2023-05-31 14:14:44
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYySqxx extends GxYySqxxKz implements Serializable {
    private static final long serialVersionUID = 6341229705927508451L;
    /**
     * 申请id
     */
    private String sqid;

    /**
     * 申请号
     */
    private String sqh;

    /**
     * 登记类型;字典项
     */
    @ZdTypeConfig(field = "djlx", tableName = ZdTypeConstant.ZD_TYPE_DJLX, mcToDM = true, checkChinese = true)
    private String djlx;

    /**
     * 申请登记类型（组合流程存放小类）
     */
    private String sqdjlx;

    /**
     * 权利类型;字典项
     */
    @ZdTypeConfig(field = "qllx", tableName = ZdTypeConstant.ZD_TYPE_QLLX, mcToDM = true, checkChinese = true)
    private String qllx;

    /**
     * 共有方式;字典项
     */
    @ZdTypeConfig(field = "gyfs", tableName = ZdTypeConstant.ZD_TYPE_GYFS, mcToDM = true, checkChinese = true)
    private String gyfs;

    /**
     * 是否分别持证 0:否  1:是
     */
    private String sffbcz;

    private String bdcdyh;

    /**
     * 交易价格
     */
    private Double jyjg;

    /**
     * 被担保主债权数额
     */
    private Double bdbzzqse;

    /**
     * 债务履行期限开始日期
     */
    private Date zwlxqxksrq;

    /**
     * 债务履行期限结束日期
     */
    private Date zwlxqxjsrq;

    /**
     * 评估价值
     */
    private Double pgjz;

    /**
     * 抵押范围
     */
    private String dyfw;

    /**
     * 抵押方式;字典项
     */
    @ZdTypeConfig(field = "dyfs", tableName = ZdTypeConstant.ZD_TYPE_DYFS, mcToDM = true, checkChinese = true)
    private String dyfs;

    /**
     * 贷款方式;字典项
     */
    @ZdTypeConfig(field = "dkfs", tableName = ZdTypeConstant.ZD_TYPE_DKFS, mcToDM = true, checkChinese = true)
    private String dkfs;

    /**
     * 原不动产权证证号
     */
    private String ybdcqzh;

    /**
     * 验证状态
     */
    private Integer yzzt;

    /**
     * 导出状态 0:未导出，1：已导出
     */
    private Integer dczt;

    /**
     * 申请状态 0：未审核，1：审核中，2：已通过，3：未通过，4：预审通过，5：预审未通过，6：用户撤回，7：办结，8：会签通过，9：已审核，10：会签不通过
     */
    private Integer slzt;

    /**
     * 受理信息反馈信息也可以是验证的信息。
     */
    private String slxx;

    /**
     * 备注(注销登记的注销原因也放在该字段)
     */
    private String bz;

    /**
     * 创建用户
     */
    private String createUser;

    /**
     * 创建人员(gx_yy_user.USER_GUID)
     */
    private String createUserid;

    /**
     * 创建日期
     */
    private Date createDate;

    /**
     * 管理员审核日期
     */
    private Date editDate;

    /**
     * 不动产价值
     */
    private Float bdcjz;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 抵押顺位
     */
    private Integer dysw;

    /**
     * 申请证书版式
     */
    private String sszsbs;

    /**
     * 不动产类型
     */
    @ZdTypeConfig(field = "bdclx", tableName = ZdTypeConstant.ZD_TYPE_BDCLX, mcToDM = true, checkChinese = true)
    private String bdclx;

    private Double mj;

    /**
     * 用途
     */
    @ZdTypeConfig(field = "yt", tableName = ZdTypeConstant.ZD_TYPE_FWYT, mcToDM = true, checkChinese = true)
    private String yt;

    /**
     * 宗地/宗海权利性质
     */
    @ZdTypeConfig(field = "zdzhqlxz", tableName = ZdTypeConstant.ZD_TYPE_ZDZHQLXZ, mcToDM = true, checkChinese = true)
    private String zdzhqlxz;

    /**
     * 构筑物类型
     */
    @ZdTypeConfig(field = "gzwlx", tableName = ZdTypeConstant.ZD_TYPE_GZWLX, mcToDM = true, checkChinese = true)
    private String gzwlx;

    /**
     * 单位
     */
    @ZdTypeConfig(field = "mjdw", tableName = ZdTypeConstant.ZD_TYPE_MJDW, mcToDM = true, checkChinese = true)
    private String mjdw;

    /**
     * 申请类型 字典项
     */
    private String sqlx;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 土地证号
     */
    private String tdzh;

    /**
     * 申请信息来源，1为微信，3为APP，2为web,4为其他
     */
    private Integer sqxxly;

    /**
     * 区域代码
     */
    private String qydm;

    private String dcxx;

    /**
     * 异议事项
     */
    private String yysx;

    /**
     * 买卖合同编号
     */
    private String mmhth;

    private String djzx;

    /**
     * 0是商品房买卖，1是存量房买卖
     */
    private String gmspf;

    /**
     * 抵押银行代码
     */
    private String dyyhdm;

    /**
     * 是否抵押（0是，1否）
     */
    private String sfdy;

    /**
     * 房产证号
     */
    private String fczh;

    /**
     * 建议预约时间
     */
    private String yysj;

    /**
     * 管理员审核人员gx_yy_user.USER_GUID
     */
    private String editUser;

    /**
     * 发送短信备注
     */
    private String remark;

    /**
     * 是否邮寄（0是，1否）
     */
    private String sfyj;

    /**
     * 邮寄地址
     */
    private String yjdz;

    /**
     * 申请信息类型，sq：普通申请spwx：视频问询
     */
    private String sqxxlx;

    /**
     * 坐落脱敏
     */
    private String zlTm;

    /**
     * 是否查封
     */
    private String sfcf;

    private String htqdrq;

    /**
     * 合同备案时间
     */
    private String barq;

    /**
     * 证书来源（2：新证书3：老证书）
     */
    private String zsly;

    /**
     * 不动产单元编号
     */
    private String bdcdybh;

    /**
     * 是否存在中介信息（0：是，1 ：否）
     */
    private String sfczzjxx;

    /**
     * 创建人所在部门
     */
    private String createOrgId;

    /**
     * 是否是下属部门的件(0:否，1:是）
     */
    private String isXsbm;

    /**
     * 权利人名称（冗余字段，名称以都好隔开）
     */
    private String qlrmc;

    /**
     * 权利人证件号（冗余字段，以逗号隔开）
     */
    private String qlrzjh;

    /**
     * 义务人名称（冗余字段，以逗号隔开）
     */
    private String ywrmc;

    /**
     * 义务人证件号（冗余字段，以逗号隔开）
     */
    private String ywrzjh;

    /**
     * 操作人所在部门
     */
    private String updateOrgId;

    /**
     * 契税满两年 0 未满两年 1 满两年 放代码
     */
    private String qsmln;

    /**
     * 项目id
     */
    private String xmid;

    /**
     * 房产证号list（分别持证时，以逗号隔开）
     */
    private String fczhList;

    /**
     * 首付款（元）
     */
    private String sfk;

    /**
     * 贷款金额（元）
     */
    private String dkje;

    /**
     * 付款方式代码，字典项（元）
     */
    private String fkfs;

    /**
     * 登记原因代码,字典项
     */
    private String djyy;

    /**
     * 业务系统受理编号（业务系统返回值）
     */
    private String ywxtslbh;

    /**
     * 预告证明
     */
    private String ygzm;

    /**
     * 预告抵押证明
     */
    private String ygdyzm;

    /**
     * 是否资金监管
     */
    private String sfzjjg;

    /**
     * 税务状态（gx_yy_zd_type.ZD_TYPE=SWZT）
     */
    private String swzt;

    /**
     * 税务审核信息
     */
    private String swshxx;

    /**
     * 房源编号(税务)
     */
    private String fybh;

    /**
     * 缴费状态（0:未缴费 1:部分缴费 2:已缴费）
     */
    private String jfzt;

    /**
     * 预审通过时间
     */
    private Date yytgsj;

    /**
     * 预审提示信息
     */
    private String ystsxx;

    /**
     * 取得价格
     */
    private String qdjg;

    /**
     * 抵押证明号
     */
    private String dyzmh;

    /**
     * 子类型代码（gx_yy_zd_sqlx_zlx表zdm字段）
     */
    private String zlxdm;

    /**
     * 业务号，用来存储合同信息接口返回的业务号
     */
    private String ywh;

    /**
     * 导出次数
     */
    private Integer exportcount;

    /**
     * 审核部门ID
     */
    private String shOrgId;

    /**
     * 房产类型
     */
    private String fclx;

    /**
     * 受理编号 字符反转字段（冗余字段，为了更友好的支持模糊查找）
     */
    private String slbhReverse;

    /**
     * 登记时间（获取登记系统参数）
     */
    private String djsj;

    /**
     * 购房发票号码
     */
    private String gffphm;

    /**
     * 购房发票代码
     */
    private String gffpdm;

    /**
     * 债务人
     */
    private String zwr;

    /**
     * 抵押面积
     */
    private String dymj;

    /**
     * 抵押面积其中土地
     */
    private String dymjqztd;

    /**
     * 抵押物价值
     */
    private String dywjz;

    /**
     * 被担保债权数额其中土地
     */
    private String bdbzzqseqztd;

    /**
     * 抵押物价值其中土地
     */
    private String dywjzqztd;

    /**
     * 最高债权确定事实
     */
    private String zgzqqdss;

    /**
     * 附记
     */
    private String fj;

    /**
     * roomid
     */
    private String roomid;

    /**
     * 政务网受理编号保存数据库，以便后续使用
     */
    private String zwwslbh;

    /**
     * 会签方式（0三方会签，1开发商待办）
     */
    private String hqfs;

    /**
     * 税务部门预审orgid
     */
    private String swOrgid;

    /**
     * 土地抵押面积
     */
    private String tddymj;

    /**
     * 房屋抵押面积
     */
    private String fwdymj;

    /**
     * 权证印刷序列号（印制号）
     */
    private String qzysxlh;

    /**
     * 证书id
     */
    private String zsid;

    /**
     * 是否移交推送登记系统（0：否，1：是）
     */
    private String isYjts;

    /**
     * 是否办理遗失公告1:是，0：否
     */
    private String sfblysgg;

    /**
     * 登记系统创建时间
     */
    private Date djxtcjsj;

    /**
     * 交易ID（税务系统返回）
     */
    private String jyid;

    /**
     * 云签状态(1：未签署，2：已签署或者免签署）
     */
    private String yqzt;

    /**
     * 申请事由
     */
    private String sqsy;

    /**
     * 退件原因
     */
    private String tjyy;

    /**
     * 是否主房（0:否，1:是）
     */
    private String sfzf;

    /**
     * 是否组合贷款(0否，1是)
     */
    private String sfzhdk;

    /**
     * 上报状态(0:上报中 1 ：上报失败 2：上报成功 4：未上报)
     */
    private String sbgjyczt;

    /**
     * 税费承担(字典项)
     */
    private String sfcd;

    /**
     * 争议解决方式(字典项)
     */
    private String zyjjfs;

    /**
     * 抵押贷款类别（字典项）
     */
    private String dydklb;

    /**
     * 最高债权确定事实名称
     */
    private String zgzqqdssmc;

    /**
     * 权利设定方式dm
     */
    private String qlsdfs;

    /**
     * 被执行人信息查询描述
     */
    private String bzxrxxcxms;

    /**
     * 查询结果说明
     */
    private String cxjgsm;

    /**
     * 证书形式代码（1：纸质证2：电子证）
     */
    private String zsxsdm;

    /**
     * 房屋ID(房屋编号,税务返回)
     */
    private String fwuuid;

    /**
     * 权籍关联代码(字典项QJGL)
     */
    private String qjgldm;

    /**
     * 使用期限
     */
    private String syqx;

    /**
     * 产权来源
     */
    private String cqly;

    /**
     * 登记接收人名称
     */
    private String djjsrmc;

    /**
     * 登记接收人ID
     */
    private String djjsrid;

    /**
     * 一卡清状态（YKQZT字典）
     */
    private String ykqzt;

    /**
     * 申请按份共有的权利人处分方式（0:经占份额三分之二以上的共有人同意,1: 全体共同共有人同意,放代码）
     */
    private String cffs;

    /**
     * 企业备案编号
     */
    private String qybabh;

    /**
     * 缴费状态时间
     */
    private Date jfztsj;

    /**
     * 申请书内容
     */
    private String sqsnr;

    /**
     * 水电气过户id
     */
    private String sdqghid;

    /**
     * 是否已领取纸质登记证明（0：否，1：是）
     */
    private String sfylqzzdjzm;

    /**
     * 第三方服务收件时间（示例：2022-12-11 21:12:33），存的第三方的收件时间
     */
    private String dsffwsjsj;

    private String zssfyggzf;

    /**
     * 登记事由
     */
    private String djsy;
    /**
     * 证书类型（1：生成证书，2：生成证明，3：只登簿不发证）
     */
    private String zslx;
    /**
     * 统计数量
     */
    private Integer totalCount;
    /**
     * 查询目的
     */
    private String cxmd;

    /**
     * 查询目的手填
     */
    private String cxmdst;

    /**
     * 是否带押过户
     */
    private String sfdygh;
    /**
     * 是否无还本续贷款
     */
    private String sfwhbxd;

    /**
     * 是否提供现场服务
     */
    private String sftgxcfw;

    /**
     * 扩展字段json，新增字段都以json方式放该字段里面
     */
    private String kzJson;
}

