package cn.gtmap.hlw.core.enums.dict.sign;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
 * @version 1.0, 2023/7/17
 * @description 云签厂商代码
 */
@Getter
@AllArgsConstructor
public enum SignCsdmEnum {

    /**
     * 云签厂商代码枚举
     */
    CSDM_ESIGN_PUBLIC("ESIGN_PUBLIC", "E签宝公有云"),
    CSDM_ESIGN_AHZWW("ESIGN_AHZWW", "安徽政务网云签"),
    CSDM_ESIGN_XCSJFZ("ESIGN_AHZWW", "安徽宣城市级云签"),
    CSDM_ESIGN_ORG_PH("ESIGN_ORG_PH", "普华电子签章"),
    CSDM_ESIGN_AHCA_GR("ESIGN_AHCA_GR", "安徽CA（个人）"),
    CSDM_ESIGN_MIX("ESIGN_MIX", "E签宝混合云"),
    CSDM_ESIGN_ORG_LYGZWZT("ESIGN_ORG_LYGZWZT", "连云港手机端政务中台数字签字"),
    CSDM_ESIGN_JSHSL("ESIGN_JSHSL", "江苏慧世联"),
    CSDM_ESIGN_ZJGDSJ("ESIGN_ZJGDSJ", "张家港大数据"),
    CSDM_ESIGN_KSBL("ESIGN_KSBL", "昆山博浪"),
    CSDM_ESIGN_WXQ("ESIGN_WXQ", "皖信签"),
    CSDM_ESIGN_DX("DX_ESIGN", "电信"),
    CSDM_ESIGN_DXSPB("DX_SPB_ESIGN", "电信视频办");


    @Getter
    private String dm;

    @Getter
    private String mc;
}
