package cn.gtmap.hlw.core.model.query;

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/8 16:33
 * @description GeneratePdfParamsModel
 */
@Data
public class GeneratePdfParamsModel {
    /**
     *
     */
    private String lysjdm;

    /**
     *
     */
    private String processId;

    /**
     * 节点代码 节点事件需要
     */
    private String jddm;
    /**
     * 按钮id
     */
    private String anid;

    /**
     * 受理编号
     */
    private String slbh;
    /**
     * sqid
     */
    private String sqid;

    /**
     * 区域代码
     */
    private String qydm;

    /**
     * 区域代码
     */
    private String sqlx;


    /**
     * 区域代码
     */
    private String qlrlx;

    /**
     * 附件类型
     */
    private String fjlx;

    /**
     * 领域动作集合对应的附件类型集合
     */
    private List<String> lydzFjlxList;

    /**
     * 登记原因
     */
    private String djyy;

    /**
     * 是否存储附件 默认存储到附件信息表，等于false时，不存储
     */
    private Boolean sfccfj;

    /**
     * 权利人名称
     */
    private String qlrmc;
    /**
     * 权利人证件号
     */
    private String qlrzjh;
    /**
     * 义务人名称
     */
    private String ywrmc;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 产权证号
     */
    private String cqzh;
    /**
     * 坐落
     */
    private String zl;
    /**
     * 开始时间：yyyy-mm-dd 00:00:00  gx_yy_sqxx.create_date
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date kssj;

    /**
     * 开始时间：yyyy-mm-dd 23:59:59  gx_yy_sqxx.create_date
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date jssj;
    /**
     * 导出状态
     */
    private String dczt;
    /**
     * 登陆人 此字段对应 gx_yy_sqxx.create_userid
     */
    private String userGuid;
    /**
     * 当前登陆人所属部门  此字段不作为查询条件，放在orgIdList作为查询条件
     */
    private String orgId;
    /**
     * 本部门及下属之部门OrgId; gx_yy_sqxx.create_org_id
     */
    private List<String> orgIdList;

    private List<String> slbhList;

    /**
     * 是否加盖银行公章  1是 0 否
     */
    private String sfjgyhgz;
    /**
     * xmid
     */
    private String xmid;
    /**
     * 不动产类型
     */
    private String bdclx;
    /**
     * 文件名称
     */
    private String wjmc;
    /**
     * id
     */
    private String id;
    /**
     * webUrl
     */
    private String webUrl;
    /**
     * 是否适用于签字板，1：是  0：否
     */
    private String sfsyqzb;
    /**
     * 查询用途
     */
    private String cxyt;
    /**
     * 移交单号
     */
    private String yjdh;
    /**
     * 抵押业务类型
     */
    private String dyywlx;
    private String cqmj;
    private String fwytmc;
    /**
     * 家庭成员集合
     */
    private List<GeneratePdfJtcyParamsModel> jtcyList;

}
