package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.dto.resource.resource.ResourceListParamsDTO;
import cn.gtmap.hlw.core.model.GxYyResource;

import java.util.List;

/**
 * (GxYyResource)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:19:33
 */
public interface GxYyResourceRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyResource get(String id);

    /**
     * 新增数据
     *
     * @param gxYyResource 实例对象
     * @return 影响行数
     */
    void save(GxYyResource gxYyResource);

    /**
     * 修改数据
     *
     * @param gxYyResource 实例对象
     * @return 影响行数
     */
    void update(GxYyResource gxYyResource);

    /**
     * 获取数据
     *
     * @param resourcesIds 资源id集合
     * @return 影响行数
     */
    List<GxYyResource> getResourceByResourceIds(List<String> resourcesIds);

    /**
     * 获取数据
     *
     * @param resourcesIds 资源id集合
     * @return 影响行数
     */
    List<GxYyResource> getResourceByResourceIds(String resourcesIds);

    /**
     * 保存或更新
     *
     * @param gxYyResource 实例对象
     */
    void saveOrUpdate(GxYyResource gxYyResource);

    /**
     * 资源列表
     * @param queryDTO
     * @return
     */
    List<GxYyResource> list(ResourceListParamsDTO queryDTO);
}

