package cn.gtmap.hlw.core.model;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/13 14:55
 * @description 登录入参接口
 */
@Data
public class LoginParamsModel {
    /**
     * 用户账号 对应gx_yy_user表里的 lxdh、userZjid、userName
     */
    @NotNull
    private String loginName;

    /**
     * 用户密码 对应gx_yy_user表里的userPwd
     */
    private String loginPwd;

    /**
     * 用户登陆类型 person:个人；organize：组织；interface：接口；djjg：登记机构/管理员
     */
    private String loginType;

    /**
     * 领域事件代码
     */
    @NotNull
    private String lysjdm;

    /**
     * 登录来源 1:微信，2：PC端，3：app，4：interface接口
     */
    @NotNull
    private String origin;

    private LoginResultModel resultModel;
    /**
     * 用户信息
     */
    private GxYyUser gxYyUser;

    /**
     * 短信验证码
     */
    private String yzm;
    /**
     * 角色id
     */
    private String roleId;
    /**
     * 图形验证码
     */
    private String txyzm;
    /**
     * ca证书
     */
    private String ca;

    /**
     * 其他系统ticket
     */
    private String ticket;
}
