package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * pdf文件签章模板(GxYyZdQzmb)表实体类BO
 *
 * @author makejava
 * @since 2023-05-31 16:38:58
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyZdQzmb implements Serializable {
    private static final long serialVersionUID = 6514259214587056052L;
    private String guid;

    /**申请类型*/
    private String sqlx;

    /**pdf模板文件名称*/
    private String pdfmc;

    private Integer qzlx;

    /**签名位置*/
    private Integer qmwz;

    /**默认X坐标（地区不可更改）*/
    private String x;

    /**默认Y坐标（地区不可更改）*/
    private String y;

   /**私有坐标X轴（地区可根据该坐标微调）*/
    private String syzbX;

    /**私有坐标Y轴（地区可根据该坐标微调）*/
    private String syzbY;

    private String qmzsssbl;

    /**权利人类型（1：权利人，2义务人）*/
    private String qlrlx;

    /**是否添加签署时间(0:否  1:是默认不添加，格式 yyyy-MM-dd)*/
    private String sftjqssj;

    /**签署区宽(默认印章宽度)*/
    private String qsqk;

    /**签署区高(默认印章高度)*/
    private String qsqg;

    /**签章页码（默认第一页pdf）*/
    private String qzym;

    /**关键字*/
    private String gjz;


}

