package cn.gtmap.hlw.core.enums.spxx;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/11/8
 * @description 审批状态枚举
 */
@Getter
@AllArgsConstructor
public enum SpztEnum {
    /**
     * 未审核
     */
    SPZT_WSH("1", "未审核"),
    /**
     * 审核通过
     */
    SPZT_SHTG("2", "审核通过"),
    /**
     * 审核未通过
     */
    SPZT_SHWTG("3", "审核未通过"),

    /**
     * 已审核
     */
    SPZT_YSH("9", "已审核"),
    /**
     * 登簿
     */
    SPZT_DB("14", "登簿"),
    /**
     * 核税
     */
    SPZT_HS("40", "核税"),
    /**
     * 完税
     */
    SPZT_WS("90", "完税");

    private String code;

    private String msg;
}
