package cn.gtmap.hlw.core.util.validator;

import cn.gtmap.hlw.core.enums.error.ErrorEnum;
import cn.gtmap.hlw.core.exception.BizException;
import cn.gtmap.hlw.core.util.string.StringUtil;
import org.springframework.util.CollectionUtils;

import javax.validation.ConstraintValidatorContext;
import java.util.Collection;

/**
 * @version V1.0
 * @Description 校验工具类
 * @Author admin
 * @Date 2022/12/29 17:11
 **/
public class ValidationUtils {

    /**
     * @return void
     * @Description 校验是否为空
     * @Author admin
     * @Date 2022/12/29 17:12
     * @Param [obg：校验对象, msg：校验异常输出信息]
     **/
    public static void isEmpty(String msg, Object obg) {
        if (obg == null || "".equals(obg)) {
            throw new BizException(ErrorEnum.ILLEGAL_ARGUMENT, msg);
        }
    }

    /**
     * @return void
     * @Description 校验是否为空
     * @Author admin
     * @Date 2022/12/29 17:12
     * @Param [msg：校验异常输出信息, css：校验对象，可同时输入多个String类型的入参]
     **/
    public static void isContainEmpty(String msg, String... css) {
        if (StringUtil.isContainEmpty(css)) {
            throw new BizException(ErrorEnum.ILLEGAL_ARGUMENT, msg);
        }
    }

    /**
     * @Description 校验集合类是否为空
     * @Author admin
     * @Date 2022/12/29 17:12
     * @Param [collection：校验集合, msg：校验异常输出信息]
     **/
    public static void isNullOrEmpty(Collection<?> collection, String msg) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BizException(ErrorEnum.ILLEGAL_ARGUMENT, msg);
        }

    }

    /**
     * 重置提示信息
     * @param context
     * @param message
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    public static void reset(ConstraintValidatorContext context, String message) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }

}
