package cn.gtmap.hlw.core.util.validator;

import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/11/15 9:03
 * @description IdCardVailatorUtils
 */
public class IdCardVailatorUtils {

    /**
     * 获取性别
     *
     * @param zjh
     */
    public static String getSexName(String zjh) {
        if (zjh == null || zjh.length() != 18) {
            return null;
        }
        int genderCode = Integer.parseInt(zjh.substring(16, 17));
        if (genderCode % 2 == 0) {
            return "女";
        } else {
            return "男";
        }
    }

    /**
     * 验证成年
     *
     * @param zjh
     * @return:java.lang.Integer
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    public static Boolean checkCn(String zjh) {
        if (zjh == null || zjh.length() != 18) {
            return false;
        }
        String birthdayStr = zjh.substring(6, 14);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate birthDate = LocalDate.parse(birthdayStr, formatter);

        // 计算当前日期与出生日期的年龄差
        LocalDate currentDate = LocalDate.now();
        Period period = Period.between(birthDate, currentDate);
        int age = period.getYears();
        return age >= 18;
    }
}
