package cn.gtmap.hlw.core.util.file;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/12/28
 * @description
 */
@Slf4j
public class JsonUtils {

    /**
     * 导出json文件
     *
     * @param response
     * @param obj
     * @param fileName
     * @return:void
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    public static void exportJson(HttpServletResponse response, Object obj, String uploadPath, String fileName) {
        FileInputStream fis = null;
        OutputStream os = null;
        try {
            //处理文件名中的斜杠和反斜杠
            fileName = fileName.replaceAll("[\\\\/]", "_");
            String jsonString = JSON.toJSONString(obj,
                    SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue,
                    SerializerFeature.WriteDateUseDateFormat);

            String fullPath = uploadPath + File.separator + "export";
            // 创建目录
            FileUtil.mkdir(fullPath);
            File file = new File(fullPath + File.separator + fileName);
            Writer write = new OutputStreamWriter(new FileOutputStream(file), StandardCharsets.UTF_8);
            write.write(jsonString);
            write.flush();
            write.close();
            fis = new FileInputStream(file);
            // force-download
            response.setContentType("application/force-download");
            response.setHeader("Content-Disposition", "attachment;filename="
                    .concat(String.valueOf(URLEncoder.encode(fileName, "UTF-8"))));
            response.setCharacterEncoding("utf-8");

            os = response.getOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = fis.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        } catch (Exception e) {
            log.error("exportJson", e);
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException e) {
                    log.error("exportJson", e);
                }
            }
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    log.error("exportJson", e);
                }
            }
        }
    }
}
