package cn.gtmap.hlw.core.service;

import cn.gtmap.hlw.core.constant.jkgl.JkglConstant;
import cn.gtmap.hlw.core.dto.jkgl.*;
import cn.gtmap.hlw.core.model.GxYyJkgl;
import cn.gtmap.hlw.core.model.GxYyJksx;
import cn.gtmap.hlw.core.model.GxYyXtjr;
import cn.gtmap.hlw.core.model.JkglModel;
import cn.gtmap.hlw.core.repository.GxYyJkglRepository;
import cn.gtmap.hlw.core.repository.GxYyJksxRepository;
import cn.gtmap.hlw.core.repository.GxYyXtjrRepository;
import cn.gtmap.hlw.core.repository.HlwPzPzxRepository;
import cn.gtmap.hlw.core.util.bean.BeanConvertUtil;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/3/31
 * @description
 */
@Slf4j
@Component
public class GxYyJkglService {
    @Autowired
    HlwPzPzxRepository hlwPzPzxRepository;
    @Autowired
    GxYyJkglRepository gxYyJkglRepository;
    @Autowired
    GxYyXtjrRepository gxYyXtjrRepository;
    @Autowired
    GxYyJksxRepository jksxRepository;

    public JkglModelDTO getJkglModelDtoForUrl(String xzqydm, String jkgjz) {
        if (StringUtils.isBlank(jkgjz)) {
            return null;
        }
        if (StringUtils.isBlank(xzqydm)) {
            xzqydm = hlwPzPzxRepository.getHlwPzPzxValueByPzxKey(JkglConstant.REGISTER_DWDM);
        }

        JkglModel jkglModel = getJkglModelForUrl(xzqydm, jkgjz);
        if (jkglModel != null) {
            xzqydm = jkglModel.getXzqydm();
        }
        if (jkglModel == null || StringUtils.isAnyBlank(jkglModel.getJkgjz(), jkglModel.getJkdz(), jkglModel.getXtdm())) {
            return null;
        }
        JkglModelDTO result = BeanConvertUtil.copy(jkglModel, JkglModelDTO.class);
        if (!jkglModel.getSfxytoken()) {
            return result;
        }
        JkglModel tokenJkglmodel = getJkglModel(xzqydm, jkglModel.getXtdm() + ".token.key");
        if (tokenJkglmodel == null || StringUtils.isAnyBlank(tokenJkglmodel.getJkgjz(), tokenJkglmodel.getJkdz(), tokenJkglmodel.getXtdm())) {
            return null;
        }
        result.setTokenJkglDTO(BeanConvertUtil.copy(tokenJkglmodel, JkglModelDTO.class));
        return result;
    }

    private JkglModel getJkglModelForUrl(String xzqydm, String jkgjz) {
        if (StringUtils.isAnyBlank(xzqydm, jkgjz)) {
            return null;
        }
        JkglModel jkglResultBO = new JkglModel();
        //查询接口实现表
        GxYyJkgl gxYyJkgl = gxYyJkglRepository.query(xzqydm, jkgjz);
        if (gxYyJkgl == null || StringUtils.isAnyBlank(gxYyJkgl.getXtdm(), gxYyJkgl.getId(), gxYyJkgl.getJkdz())) {
            gxYyJkgl = gxYyJkglRepository.query(xzqydm, jkgjz);
            if (gxYyJkgl == null || StringUtils.isAnyBlank(gxYyJkgl.getXtdm(), gxYyJkgl.getId(), gxYyJkgl.getJkdz())) {
                log.info("接口管理表缺少配置项(gx_yy_jkgl),行政区划:{},接口关键字:{}", xzqydm, jkgjz);
                return null;
            }
        }
        //查询系统接入表
        GxYyXtjr gxYyXtjr = gxYyXtjrRepository.query(xzqydm, gxYyJkgl.getXtdm());
        if (gxYyXtjr == null || StringUtils.isAnyBlank(gxYyXtjr.getXtdm(), gxYyXtjr.getXtdz())) {
            log.info("接口关键字:{}", jkgjz);
            log.info("接口管理表缺少系统接入(gx_yy_xtjr)配置项,行政区划:{},系统代码:{}", xzqydm, gxYyJkgl.getXtdm());
            return null;
        }
        jkglResultBO.setXtdm(gxYyXtjr.getXtdm());
        jkglResultBO.setXtdz(gxYyXtjr.getXtdz());
        jkglResultBO.setJryhmc(gxYyXtjr.getJryhmc());
        jkglResultBO.setJryhmm(gxYyXtjr.getJryhmm());
        jkglResultBO.setJrqtcs(gxYyXtjr.getJrqtcs());
        jkglResultBO.setJkzddz(gxYyXtjr.getXtdm().toUpperCase() + ":");
        jkglResultBO.setXzqydm(gxYyXtjr.getXzqydm());
        jkglResultBO.setJkgjz(gxYyJkgl.getJkgjz());
        jkglResultBO.setJkrcgljg(gxYyJkgl.getJkrcgljg());
        jkglResultBO.setJkdz(gxYyJkgl.getJkdz().replace("${" + gxYyXtjr.getXtjrgjz() + "}", gxYyXtjr.getXtdz()));
        jkglResultBO.setJkmc(gxYyJkgl.getJkmc());
        jkglResultBO.setHddz(gxYyJkgl.getHddz());
        jkglResultBO.setSfxytoken(StringUtils.equals("1", gxYyJkgl.getSfxytoken()));
        jkglResultBO.setSfjmjkrc(StringUtils.equals("1", gxYyJkgl.getSfjmjkrc()));
        return jkglResultBO;
    }

    /**
     * 获取接口管理model
     *
     * @param jkgjz
     * @return
     */
    public JkglModelDTO getJkglModelDTO(String jkgjz) {
        String xzqydm = hlwPzPzxRepository.getHlwPzPzxValueByPzxKey(JkglConstant.REGISTER_DWDM);
        return getJkglModelDTO(xzqydm, jkgjz);
    }

    /**
     * 获取接口管理model
     *
     * @param xzqydm
     * @param jkgjz
     * @return
     */
    public JkglModelDTO getJkglModelDTO(String xzqydm, String jkgjz) {
        if (StringUtils.isBlank(jkgjz)) {
            return null;
        }
        if (StringUtils.isBlank(xzqydm)) {
            xzqydm = hlwPzPzxRepository.getHlwPzPzxValueByPzxKey(JkglConstant.REGISTER_DWDM);
        }

        JkglModel jkglModel = getJkglModel(xzqydm, jkgjz);
        if (jkglModel != null) {
            xzqydm = jkglModel.getXzqydm();
        }
        if (jkglModel == null || StringUtils.isAnyBlank(jkglModel.getJkgjz(), jkglModel.getJkdz(), jkglModel.getXtdm())) {
            return null;
        }
        JkglModelDTO result = BeanConvertUtil.copy(jkglModel, JkglModelDTO.class);
        if (!jkglModel.getSfxytoken()) {
            return result;
        }
        JkglModel tokenJkglmodel = getJkglModel(xzqydm, jkglModel.getXtdm() + ".token.key");
        if (tokenJkglmodel == null || StringUtils.isAnyBlank(tokenJkglmodel.getJkgjz(), tokenJkglmodel.getJkdz(), tokenJkglmodel.getXtdm())) {
            return null;
        }
        result.setTokenJkglDTO(BeanConvertUtil.copy(tokenJkglmodel, JkglModelDTO.class));
        return result;
    }

    //TODO 加入缓存机制
    public JkglModel getJkglModel(String xzqydm, String jkgjz) {
        if (StringUtils.isAnyBlank(xzqydm, jkgjz)) {
            return null;
        }
        JkglModel jkglResultBO = new JkglModel();
        //查询接口实现表
        GxYyJkgl gxYyJkgl = gxYyJkglRepository.query(xzqydm, jkgjz);
        if (gxYyJkgl == null || StringUtils.isAnyBlank(gxYyJkgl.getXtdm(), gxYyJkgl.getId(), gxYyJkgl.getJkdz())) {
            gxYyJkgl = gxYyJkglRepository.query(xzqydm, jkgjz);
            if (gxYyJkgl == null || StringUtils.isAnyBlank(gxYyJkgl.getXtdm(), gxYyJkgl.getId(), gxYyJkgl.getJkdz())) {
                log.info("接口管理表缺少配置项(gx_yy_jkgl),行政区划:{},接口关键字:{}", xzqydm, jkgjz);
                return null;
            }
        }
        //查询系统接入表
        GxYyXtjr gxYyXtjr = gxYyXtjrRepository.query(xzqydm, gxYyJkgl.getXtdm());
        if (gxYyXtjr == null || StringUtils.isAnyBlank(gxYyXtjr.getXtdm(), gxYyXtjr.getXtdz())) {
            log.info("接口关键字:{}", jkgjz);
            log.info("接口管理表缺少系统接入(gx_yy_xtjr)配置项,行政区划:{},系统代码:{}", xzqydm, gxYyJkgl.getXtdm());
            return null;
        }
        //查询接口实现类名称
        GxYyJksx jksxDO = jksxRepository.query(gxYyJkgl.getId());
        if (jksxDO == null || StringUtils.isBlank(jksxDO.getJksxlmc())) {
            log.info("接口管理表缺少接口实现(gx_yy_jksx)配置项,接口关键字:{},gxYyJkglId:{}", jkgjz, gxYyJkgl.getId());
            return null;
        }
        jkglResultBO.setXtdm(gxYyXtjr.getXtdm());
        jkglResultBO.setXtdz(gxYyXtjr.getXtdz());
        jkglResultBO.setJryhmc(gxYyXtjr.getJryhmc());
        jkglResultBO.setJryhmm(gxYyXtjr.getJryhmm());
        jkglResultBO.setJrqtcs(gxYyXtjr.getJrqtcs());
        jkglResultBO.setJkzddz(gxYyXtjr.getXtdm().toUpperCase() + ":");
        jkglResultBO.setXzqydm(gxYyXtjr.getXzqydm());
        jkglResultBO.setJkgjz(gxYyJkgl.getJkgjz());
        jkglResultBO.setJkrcgljg(gxYyJkgl.getJkrcgljg());
        jkglResultBO.setJkdz(gxYyJkgl.getJkdz().replace("${" + gxYyXtjr.getXtjrgjz() + "}", gxYyXtjr.getXtdz()));
        jkglResultBO.setJkmc(gxYyJkgl.getJkmc());
        jkglResultBO.setJksxlmc(jksxDO.getJksxlmc());
        jkglResultBO.setHddz(gxYyJkgl.getHddz());
        jkglResultBO.setSfxytoken(StringUtils.equals("1", gxYyJkgl.getSfxytoken()));
        jkglResultBO.setSfjmjkrc(StringUtils.equals("1", gxYyJkgl.getSfjmjkrc()));
        return jkglResultBO;
    }
}
