package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyZtfw;

import java.util.List;

/**
 * 专题服务表(GxYyZtfw)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-12 13:34:11
 */
public interface GxYyZtfwRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyZtfw get(String id);

    /**
     * 新增数据
     *
     * @param gxYyZtfw 实例对象
     * @return 影响行数
     */
    void save(GxYyZtfw gxYyZtfw);

    /**
     * 修改数据
     *
     * @param gxYyZtfw 实例对象
     * @return 影响行数
     */
    void update(GxYyZtfw gxYyZtfw);

    /**
     * 根据角色id获取数据
     * @param roleId 角色id
     * @return 影响行数
     */
    List<GxYyZtfw> getZtfwByRoleId(String roleId);
    /**
     * 根据角色id获取数据
     * @param roleId 角色id
     * @param ztfwmc 常用登记
     * @return 影响行数
     */
    GxYyZtfw getZtfwByRoleIdAndZtfwmc(String roleId,String ztfwmc);
    /**
     * 根据角色id获取数据
     * @param roleId
     * @return:List<GxYyZtfw>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    List<GxYyZtfw> getZtfwListByRoleId(String roleId);
}

