package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.user.user.UserQueryParamsDTO;
import cn.gtmap.hlw.core.dto.user.user.UserSaveParamsDTO;
import cn.gtmap.hlw.core.dto.user.user.UserUpdateParamsDTO;
import cn.gtmap.hlw.core.model.LoginParamsModel;
import cn.gtmap.hlw.core.model.GxYyUser;

import java.util.List;

/**
 * 不动产用户表(GxYyUser)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 11:39:30
 */
public interface GxYyUserRepository {

    List<GxYyUser> getByOnemapId(String onemapId);

    /**
     * 通过ID查询单条数据
     *
     * @param userGuid 主键
     * @return 实例对象
     */
    GxYyUser get(String userGuid);

    /**
     * 新增数据
     *
     * @param gxYyUser 实例对象
     * @return 影响行数
     */
    String save(GxYyUser gxYyUser);

    /**
     * 修改数据
     *
     * @param gxYyUser 实例对象
     * @return 影响行数
     */
    void update(GxYyUser gxYyUser);

    String saveOrUpdateUser(GxYyUser gxYyUserPO);

    void updatePassword(String userGuid, String password);

    /**
     * 查询数据
     *
     * @param loginParamsModel 查询对象
     * @return 影响行数
     */
    GxYyUser getUserByQueryParams(LoginParamsModel loginParamsModel);

    /**
     * 查询数据--根据证件id
     *
     * @param userZjid
     * @return 影响行数
     */
    GxYyUser getUserByUserZjId(String userZjid);

    /**
     * 查询数据
     *
     * @param userZjid 证件id
     * @param lxdh     联系电话
     * @return 影响行数
     */
    GxYyUser getUserByZjidAndLxdh(String userZjid, String lxdh);

    /**
     * 查询数据
     *
     * @param pwd  用户密码
     * @param lxdh 联系电话（不加密）
     * @return 影响行数
     */
    List<GxYyUser> getUserByPwdAndLxdh(String pwd, String lxdh);

    /**
     * 通过联系电话查询数据
     *
     * @param lxdh 联系电话（不加密）
     * @return 实例对象集合
     */
    List<GxYyUser> getByLxdh(String lxdh);

    /**
     * 获取数据
     *
     * @return 影响行数
     */
    List<GxYyUser> getAll();

    /**
     * 获取数据
     *
     * @param userIdList 集合
     * @return 影响行数
     */
    List<GxYyUser> getByUserGuidList(List<String> userIdList);

    /**
     * 删除数据
     *
     * @param userGuid 用户id
     * @return 影响行数
     */
    int delete(String userGuid);

    /**
     * 分页查询
     *
     * @return 影响行数
     */
    PageInfo<GxYyUser> queryPage(UserQueryParamsDTO paramsDTO);

    /**
     * 根据userId和realName查询
     *
     * @param userIdList
     * @param realName
     * @return
     */
    List<GxYyUser> getByUserIdAndRealName(List<String> userIdList, String realName);

    /**
     * 查询数据
     *
     * @param useridList
     * @return:List<GxYyUser>
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     */
    List<GxYyUser> list(List<String> useridList);

    /**
     * 统计用户总数
     * @param
     * @return:Integer
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    int getCount();
    /**
     * 根据用户名查询
     * @param userName
     * @return:GxYyUser
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYyUser getByUserName(String userName);
    /**
     * 根据密码查询用户
     * @param md5PassWord
     * @return:GxYyUser
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYyUser getByPwd(String md5PassWord);
    /**
     * 根据真实名称、密码查询
     * @param userName
     * @param md5PassWord
     * @return:GxYyUser
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYyUser getByRealNameAndPwd(String userName, String md5PassWord);
    /**
     * 根据联系电话查询
     * @param lxdh
     * @return:GxYyUser
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
    */
    GxYyUser getUserByLxdh(String lxdh);

    GxYyUser getUserByUserCode(String userCode);

    /**
     * 根据联系电话和角色查询
     * @param role
     * @param lxdh
     * @return:GxYyUser
     * @author <a href="mailto:wangzhiwen@gtmap.cn">wangzhiwen</a>
     */
    GxYyUser getByRoleAndLxdh(String role, String lxdh);

    void updateValidAndReason(UserSaveParamsDTO userSaveParamsDTO);

    void updateIsHmd(UserUpdateParamsDTO userUpdateParamsDTO);
}

