package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.lysj.lydz.LydzQueryParamsDTO;
import cn.gtmap.hlw.core.model.GxYyLydz;

import java.util.List;

/**
 * 领域动作(GxYyLydz)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-06 14:39:57
 */
public interface GxYyLydzRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param lydzdm 主键
     * @return 实例对象
     */
    GxYyLydz get(String lydzdm);

    /**
     * 新增数据
     *
     * @param gxYyLydz 实例对象
     * @return 影响行数
     */
    void save(GxYyLydz gxYyLydz);

    /**
     * 修改数据
     *
     * @param gxYyLydz 实例对象
     * @return 影响行数
     */
    void update(GxYyLydz gxYyLydz);

    /**
     * 批量查询领域动作
     *
     * @param lydzdmList
     * @return
     */
    List<GxYyLydz> getList(String lydzdmList);

    /**
     * 查询全部领域动作
     *
     * @return
     */
    List<GxYyLydz> getAll();

    /**
     * 根据lydzdm删除
     *
     * @param lydzdm 领域动作代码
     */
    void deleteByLydzdm(String lydzdm);

    /**
     * 分页查询
     *
     * @param queryDTO
     * @return
     */
    PageInfo<GxYyLydz> page(LydzQueryParamsDTO queryDTO);

    /**
     * 详情
     *
     * @param queryDTO
     * @return
     */
    List<GxYyLydz> detail(LydzQueryParamsDTO queryDTO);

    /**
     * 批量保存更新
     *
     * @param lydzList 领域动作集合
     */
    void saveOrUpdateBath(List<GxYyLydz> lydzList);
}

