package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.base.PageInfo;
import cn.gtmap.hlw.core.dto.jkgl.jksx.JksxPageParamsDTO;
import cn.gtmap.hlw.core.model.GxYyJksx;

import java.util.List;

/**
 * 接口实现表(GxYyJksx)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-06 14:48:08
 */
public interface GxYyJksxRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyJksx get(String id);

    /**
     * 通过ID查询单条数据
     *
     * @param jkglid 接口管理id
     * @return 实例对象
     */
    GxYyJksx getByJkglid(String jkglid);

    /**
     * 新增数据
     *
     * @param gxYyJksx 实例对象
     * @return 影响行数
     */
    void save(GxYyJksx gxYyJksx);

    /**
     * 修改数据
     *
     * @param gxYyJksx 实例对象
     * @return 影响行数
     */
    void update(GxYyJksx gxYyJksx);

    /**
     * 根据接口管理id查询实现类
     *
     * @param jkglid
     * @return
     */
    GxYyJksx query(String jkglid);

    /**
     * 分页查询
     *
     * @param paramsDTO
     * @return PageInfo<GxYyJksx>
     */

    PageInfo<GxYyJksx> queryPage(JksxPageParamsDTO paramsDTO);

    /**
     * 根据主键删除数据
     *
     * @param id 主键
     * @return 删除的数量
     */
    int delete(String id);

    /**
     * 通过接口管理id删除数据
     *
     * @param jkglid 接口管理id
     * @return 删除的数量
     */
    int deleteByJkglid(String jkglid);

    /**
     * 保存更新
     *
     * @param gxYyJksx 接口实现
     */
    void saveOrUpdate(GxYyJksx gxYyJksx);

    /**
     * 根据jkglid查询集合
     *
     * @param jkglIdList
     * @return
     */
    List<GxYyJksx> getByJkglidList(List<String> jkglIdList);

}

