package cn.gtmap.hlw.core.repository;

import cn.gtmap.hlw.core.model.GxYyFunctionMenu;

import java.util.List;

/**
 * (GxYyFunctionMenu)表数据库访问层
 *
 * @author makejava
 * @since 2023-06-01 14:34:59
 */
public interface GxYyFunctionMenuRepository {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GxYyFunctionMenu get(String id);

    /**
     * 新增数据
     *
     * @param gxYyFunctionMenu 实例对象
     * @return 影响行数
     */
    void save(GxYyFunctionMenu gxYyFunctionMenu);

    /**
     * 修改数据
     *
     * @param gxYyFunctionMenu 实例对象
     * @return 影响行数
     */
    void update(GxYyFunctionMenu gxYyFunctionMenu);
    /**
     * 根据RoleId查询实体对象
     *
     * @param roleId 角色id
     * @return 影响行数
     */
     List<GxYyFunctionMenu> getFunctionMenu(String roleId);


    /**
     * 根据FunctionMenuId查询实体对象
     *
     * @param roleId 角色id
     * @param functionMenuId 功能菜单id
     * @return 影响行数
     */
    GxYyFunctionMenu getFunctionMenuByFunctionMenuIdAndRoleId(String functionMenuId,String roleId);


    /**
     * 根据FunctionMenuId查询实体对象
     * @param functionMenuId
     * @return
     */
    List<GxYyFunctionMenu> getFunctionMenuByFunctionMenuId(String functionMenuId);

    /**
     * 根据FunctionMenuId查询实体对象
     * @param functionMenuIds
     * @param roleId
     * @return
     */
    List<GxYyFunctionMenu> getyFunctionMenuIdsAndRoleId(List<String> functionMenuIds,String roleId);
}

