package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 不动产申请信息表(GxYySqxxLb)表实体类BO
 *
 * @author makejava
 * @since 2024-03-27 14:14:44
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYySqxxLb implements Serializable {
    private static final long serialVersionUID = 6341229705927508452L;
    /**
     * 申请id
     */
    private String sqid;

    /**
     * 申请登记类型（组合流程存放小类）
     */
    private String sqdjlx;

    private String bdcdyh;

    /**
     * 申请状态 0：未审核，1：审核中，2：已通过，3：未通过，4：预审通过，5：预审未通过，6：用户撤回，7：办结，8：会签通过，9：已审核，10：会签不通过
     */
    private Integer slzt;

    /**
     * 受理信息反馈信息也可以是验证的信息。
     */
    private String slxx;

    /**
     * 备注(注销登记的注销原因也放在该字段)
     */
    private String bz;

    /**
     * 创建日期
     */
    private Date createDate;

    /**
     * 管理员审核日期
     */
    private Date editDate;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 区域代码
     */
    private String qydm;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 权利人名称（冗余字段，名称以都好隔开）
     */
    private String qlrmc;

    /**
     * 权利人证件号（冗余字段，以逗号隔开）
     */
    private String qlrzjh;

    /**
     * 义务人名称（冗余字段，以逗号隔开）
     */
    private String ywrmc;

    /**
     * 义务人证件号（冗余字段，以逗号隔开）
     */
    private String ywrzjh;

}

