package cn.gtmap.hlw.core.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * 登记中心配置(GxYyDjzx)表实体类BO
 *
 * @author makejava
 * @since 2023-06-29 10:19:06
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyDjzx implements Serializable {

    private static final long serialVersionUID = -6919142232349627812L;
    /**登记中心编码*/
    private String djzxdm;

    /**登记中心名称*/
    private String djzxmc;

    /**登记中心地址*/
    private String djzxdz;

    /**登记中心电话*/
    private String djzxdh;

    private Integer djzxsx;

    /**登记中心时间*/
    private String djzxsj;

    /**登记中心url(哈尔滨的登记中心链接)*/
    private String djzxurl;

    private Integer test;

    /**区域代码（关联gx_yy_zd_qy表qydm字段）*/
    private String qydm;

    /**预约部门代码（合肥）*/
    private String yybmdm;

    /** 顺序号*/
    private String sxh;

    /**审核部门ID*/
    private String shOrgId;

    /**所在省*/
    private String szsheng;

    /**所在市*/
    private String szshi;

    /**所在县*/
    private String szxian;

    /**所属地区*/
    private String ssdq;

    /**行政区域划分等级_代码（关联gx_yy_zd_xzqy的dm字段）*/
    private String xzqhdm;

    /**不动产大厅海报*/
    private String billImag;

    /**大厅的介绍*/
    private String introduce;

    /**经度*/
    private String x;

    /**纬度*/
    private String y;

    /**1不可用0可用*/
    private Integer isDelete;

    /**非工作日登记中心时间*/
    private String djzxjjrsj;

    /**开始预约时间，填纯数字，0表示可以预约当天，1表示从第2填开始预约*/
    private String ksyysj;

    /**可预约天数，10表示可预约10个工作日*/
    private String kyyts;

    /**取消（后）可预约数量是否增加（加1） 0:否，1：是*/
    private String qxkyyslsfzj;


}

