package cn.gtmap.hlw.core.model;

import cn.gtmap.hlw.core.node.INode;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * (GxYyCustomNews)表实体类BO
 *
 * @author makejava
 * @since 2023-07-03 09:51:35
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GxYyCustomNews implements Serializable, INode<GxYyCustomNews> {
    private static final long serialVersionUID = -4712731947627179175L;
    /**主键 */
    private String id;

    /**标题 */
    private String title;

    /**作者*/
    private String author;

    /**HTML路径地址*/
    private String url;

    /**创建时间*/
    private Date createDate;

    /**所属类型（0:所有，1：微信，2：web）*/
    private String type;

    /**HTML文本*/
    private String content;

    /**新闻类型关联字典表*/
    private String newsType;

    /**来源*/
    private String origin;

    /**登记中心编码关联gx_yy_djzx的djzxdm字段*/
    private String djzxdm;

    /**更新时间*/
    private Date updateDate;

    /**状态（0草稿，1发布，2下架）*/
    private Integer status;

    /**置顶时间*/
    private Date zdsj;

    /**阅读量*/
    private Integer ydl;

    /**  申请类型字典gx_yy_zd_sqlx）*/
    private String sqlx;

    /**登记类型（字典gx_yy_zd_type  DJLX）*/
    private String djlx;

    /**二级标题*/
    private String secondTitle;

    /**一级标题顺序号*/
    private Integer sxh;

    /**二级标题顺序号*/
    private Integer secondSxh;

    /**是都置顶*/
    private String sfzd;


    /**
     * 父新闻id
     */
    private String parentId;

    /**
     * 子孙节点
     */
    private List<GxYyCustomNews> children;

    @Override
    public List<GxYyCustomNews> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<>();
        }
        return this.children;
    }
}

