package cn.gtmap.hlw.core.enums.web;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/10/8 10:28
 * @description http状态
 */
public enum HttpStatusEnum {

    /**
     * post 请求方式
     */
    OK_200("200","成功"),

    BAD_REQUES_400("400", "错误的请求");

    private String code;

    private String name;

    HttpStatusEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * 根据code获取枚举name
     */
    public static String getName(String code) {
        for (HttpStatusEnum xq : HttpStatusEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getName();
            }
        }
        return null;
    }
}
