package cn.gtmap.hlw.core.enums.status;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 通用状态标识 - 是否
 */
@Getter
@AllArgsConstructor
public enum StatusEnum {
    /**
     * 状态标识 - true
     */
    TRUE("0", "是"),

    /**
     * 状态标识 - false
     */
    FALSE("1", "否");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (StatusEnum xq : StatusEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

}
