package cn.gtmap.hlw.core.enums.status;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author： admin
 * @Data: 2020/12/4
 * @Description: 通用状态标识 - 是否 （兼容之前状态）
 */
@Getter
@AllArgsConstructor
public enum Status3Enum {
    /**
     * 状态标识 - 否
     */
    NO("N", "否"),

    /**
     * 状态标识 - 是
     */
    YES("Y", "是");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (Status3Enum xq : Status3Enum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }

}
