package cn.gtmap.hlw.core.enums.dict.fw;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 房屋使用用途类型
 *
 * @author admin
 * @Date 2023-06-25
 * @Version V1.0
 */
@Getter
@AllArgsConstructor
public enum FwlxEnum {

    /**
     * 住宅
     */
    FWLX_ZZ("1", "住宅"),
    /**
     * 商业用房
     */
    FWLX_SYYF("2", "商业用房"),
    /**
     * 办公用房
     */
    FWLX_BGYF("3", "办公用房"),
    /**
     * 工业用房
     */
    FWLX_GYYF("4", "工业用房"),
    /**
     * 仓储用房
     */
    FWLX_CCYF("5", "仓储用房"),
    /**
     * 车库
     */
    FWLX_CK("6", "车库"),
    /**
     * 钢砼厂房、仓库
     */
    FWLX_GTCF_CK("7", "钢砼厂房、仓库"),
    /**
     * 钢结构厂房、仓库
     */
    FWLX_GJGCF_CK("8", "钢结构厂房、仓库"),
    /**
     * 普通多层
     */
    FWLX_PTDC("9", "普通多层"),
    /**
     * 商铺
     */
    FWLX_SP_SHOPS("10", "商铺"),
    /**
     * 独栋
     */
    FWLX_DD("11", "独栋"),
    /**
     * 电梯多层
     */
    FWLX_DTDC("12", "电梯多层"),
    /**
     * 平房
     */
    FWLX_PF("13", "平房"),
    /**
     * 联排
     */
    FWLX_LP("14", "联排"),
    /**
     * 双拼
     */
    FWLX_SP_DOUBLE("15", "双拼"),
    /**
     * 小高层
     */
    FWLX_XGC("16", "小高层"),
    /**
     * 高层
     */
    FWLX_GC("17", "高层"),
    /**
     * 叠加
     */
    FWLX_DJ("18", "叠加"),
    /**
     * 车位(地上)
     */
    FWLX_CW_DS("19", "车位(地上)"),
    /**
     * 车库(地下)
     */
    FWLX_CK_DX("20", "车库(地下)"),
    /**
     * 砖混结构厂房、仓库
     */
    FWLX_ZHJGCF_CK("21", "砖混结构厂房、仓库"),
    /**
     * 独立车库、车位
     */
    FWLX_DLCK_CW("22", "独立车库、车位"),

    /**
     * 车库(地上)
     */
    FWLX_CK_DS("23", "车库(地上)"),
    /**
     * 车位(地下)
     */
    FWLX_CW_DX("24", "车位(地下)"),
    /**
     * 别墅
     */
    FWLX_BS("25", "别墅"),
    /**
     * 综合
     */
    FWLX_ZH("26", "综合"),
    /**
     * 非住宅【非居住】
     */
    FWLX_FZZ_FJZ("27", "非住宅【非居住】"),
    /**
     * 公寓
     */
    FWLX_GY("28", "公寓"),
    /**
     * 其它
     */
    FWLX_QT("99", "其它");


    private String code;

    private String msg;
}

