package cn.gtmap.hlw.core.enums.dict.fj;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/7/10 16:38
 * @description 通用附件类型
 */
@Getter
@AllArgsConstructor
public enum FjlxEnum {

    /**
     * 身份证电子证照
     */
    FJLX_SFZDZZZ(4, "身份证电子证照"),
    /**
     * 权属证书
     */
    FJLX_QSZS(6, "权属证书"),
    /**
     * 买方身份证明文件
     */
    FJLX_GFRSFZM(21, "买方身份证明"),

    /**
     * 买方婚姻状况文件
     */
    FJLX_GFRHYZK(22, "买方婚姻状况"),

    /**
     * 买方户口簿文件
     */
    FJLX_GFRHKB(23, "买方户口簿"),

    /**
     * 卖方身份证明文件
     */
    FJLX_CSRSFZM(31, "卖方身份证明"),

    /**
     * 卖方婚姻状况文件
     */
    FJLX_CSRHYZK(32, "卖方婚姻状况"),

    /**
     * 卖方户口簿文件
     */
    FJLX_CSRHKB(33, "卖方户口簿"),

    /**
     * 人证比对相关文件
     */
    FJLX_RXCJ(40, "人证比对"),

    /**
     * 抵押注销申请书 (连云港用)
     */
    FJLX_DYZXSQS2(51, "抵押注销申请书"),

    /**
     * 抵押注销证明
     */
    FJLX_DYZXZM(52, "抵押注销证明"),

    /**
     * 抵押申请书或抵押合同文件
     */
    FJLX_DYHT(108, "抵押合同"),

    /**
     * 办件人限购告知书及承诺书文件
     */
    FJLX_BJR_XGGZS_CNS(902, "限购告知书及承诺书"),

    /**
     * 存量房资源放弃交易资金托管声明文件
     */
    FJLX_CLF_ZYFQ_JYZJTG_SM(903, "存量房资源放弃交易资金托管声明"),

    /**
     * 存量房交易自行成交网上签约告知书文件
     */
    FJLX_CLF_ZXCJWSQYGZS(901, "存量房交易自行成交网上签约告知书"),

    /**
     * 转移申请书（非涉税）文件
     */
    FJLX_ZYSQS(907, "转移申请书（非涉税）"),

    /**
     * 转移申请书（涉税）文件
     */
    FJLX_ZYSQSSS(908, "转移申请书（涉税）"),
    /**
     * 承包经营权申请书
     */
    FJLX_CBJYSQS(909, "承包经营权申请书"),
    /**
     * 带押过户申请书
     */
    FJLX_DYGHSQS(910, "带押过户申请书"),
    /**
     * 预告证明
     */
    FJLX_YGZM(965, "预告证明"),

    /**
     * 税务出售人申报单文件
     */
    FJLX_SW_CSR_SBD(966, "卖方申报单"),

    /**
     * 税务购房人申报单文件
     */
    FJLX_SW_GFR_SBD(967, "买方申报单"),

    /**
     * 税务核定价格确认表文件
     */
    FJLX_SW_HDJGQRB(968, "核定价格确认表"),
    /**
     * 房价变动，税务审核不通过，返回价格明细单
     */
    FJLX_SW_JGMXD(970, "价格明细单"),

    /**
     * 不动产信息查询证明_买方、不动产信息查询证明_卖方
     */
    FJLX_BDCXXCXZM(979, "不动产信息查询证明"),

    /**
     * 税务申报确认单文件
     */
    FJLX_SW_SBQRD(983, "申报确认单"),

    /**
     * 问询笔录文件
     */
    FJLX_WXBL(999, "问询笔录"),

    /**
     * 交易合同文件（不动产买卖合同）
     */
    FJLX_JYHT(1000, "不动产买卖合同"),

    /**
     * 存量房买卖合同网上签约申请书文件
     */
    FJLX_CLF_MMHT_WSQYSQS(1002, "存量房买卖合同网上签约申请书（买卖方）"),

    /**
     * 购房人基本信息采集表文件
     */
    FJLX_GFR_JBXXCJB(1003, "购房人基本信息采集表（买方）"),

    /**
     * 购房人信息查询授权书文件
     */
    FJLX_GFR_XXCXSQS(1005, "个人信息查询授权书（买方）"),

    /**
     * 税务证明事项告知承诺书文件（买方）
     */
    FJLX_SW_ZMSJGZCNS(1006, "税务证明事项告知承诺书（买方）"),

    /**
     * 出售人信息查询授权书文件
     */
    FJLX_CSR_XXCXSQS(1007, "个人信息查询授权书（卖方）"),

    /**
     * 出售人家庭唯一生活用房保证书文件
     */
    FJLX_CSR_JTWYSHYFBZS(1008, "家庭唯一生活用房诚信保证书（卖方）"),

    /**
     * 抵押注销申请书文件
     */
    FJLX_DYZXSQS(1010, "抵押注销申请书"),

    /**
     * 抵押申请书文件
     */
    FJLX_DYSQS(1011, "抵押申请书"),

    /**
     * 转移合同文件
     */
    FJLX_ZYHT(1012, "转移合同"),

    /**
     * 不动产登记办件授权书文件
     */
    FJLX_BDCDJBJSQS(1013, "不动产登记授权书"),

    /**
     * 电子证照共享附件文件
     */
    FJLX_DZZZGXWJ(1014, "电子证照共享附件"),

    /**
     * 夫妻转让协议文件
     */
    FJLX_FQZRXY(1015, "夫妻转让协议"),

    /**
     * 不动产权证文件
     */
    FJLX_BDCQZ(1016, "不动产权证"),

    /**
     * 收件单文件
     */
    FJLX_SJD(1017, "收件单"),

    /**
     * 户室图（第三方共享）文件
     */
    FJLX_HST(1018, "户室图"),

    /**
     * 宗地图（第三方共享）文件
     */
    FJLX_ZDT(1019, "宗地图"),

    /**
     * 移交单文件
     */
    FJLX_YJD(1020, "移交单"),

    /**
     * 继承类相关事项告知书承诺书文件
     */
    FJLX_JCLXGSXGZSCNS(1021, "继承类相关事项告知书承诺书"),

    /**
     * 他项证明文件
     */
    FJLX_TXZM(1022, "他项证明"),

    /**
     * 债权灭失证明文件
     */
    FJLX_ZQMSZM(1023, "债权灭失证明"),

    /**
     * 非抵押审批表
     */
    FJLX_SPBFDY(1024, "审批表"),

    /**
     * 抵押审批表
     */
    FJLX_SPBDY(1025, "审批表"),
    /**
     * 其他共享材料
     */
    FJLX_QTGXCL(1026, "其他共享材料"),
    /**
     * 竣工移交单
     */
    FJLX_JGYJD(1027, "竣工移交单"),
    /**
     * 全款结清证明
     */
    FJLX_QKJQZM(1028, "全款结清证明"),
    /**
     * 免监管凭证
     */
    FJLX_MJGPZ(1029, "免监管凭证"),
    /**
     * 税务申报材料
     */
    FJLX_SWSBCL(1030, "税务申报材料"),
    /**
     * 税务共享材料
     */
    FJLX_SWGXCL(1031, "税务共享材料"),
    /**
     * 抵押登记申请书文件
     */
    FJLX_DYDJSQS(1201, "抵押登记申请书"),

    /**
     * 抵押登记合同文件
     */
    FJLX_DYDJHT(1202, "抵押登记合同"),
    /**
     * 公积金抵押登记合同文件
     */
    FJLX_GJJDYDJHT(1203, "公积金抵押登记合同"),
    /**
     * 期转现申请书(连云港)
     */
    FJLX_QZXSQS(1204, "期转现申请书"),
    /**
     * 法人委托书（昆山）
     */
    FJLX_FRWTS(1205, "法人委托书"),
    /**
     * 知晓函（若该产权存在二押及以上请上传）
     */
    FJLX_ZXH(1206, "知晓函"),
    /**
     * 转移登记申请书
     */
    FJLX_ZYDJSQS(1207, "转移登记申请书"),
    /**
     * 抵押信息集成表（芜湖）
     */
    FJLX_DYJCB(8884, "抵押信息集成表"),

    /**
     * 完税证明文件
     */
    FJLX_WSZM(100001, "完税证明"),

    /**
     * 电子费票文件
     */
    FJLX_DZFP(202007262, "电子费票"),

    /**
     * 电子税票文件
     */
    FJLX_DZSP(202007263, "电子税票"),
    /**
     * 存证视频
     */
    FJLX_CZSP(2307254, "存证视频"),
    /**
     * 存证证明
     */
    FJLX_CZZM(2307256, "存证证明"),
    /**
     * 电子信息表
     */
    FJLX_DZXXB(99979, "电子信息表"),
    /**
     * 电子信息表
     */
    FJLX_SPSL(972, "云签视频双录"),
    /**
     * 其他材料文件
     */
    FJLX_QT(9999, "其他材料"),
    /**
     * 企业证件
     */
    FJLX_QYZJ(1206, "企业证件"),
    /**
     * 企业注册授权书
     */
    FJLX_QYZXSQS(1207, "企业注册授权书"),
    /**
     * 企业注册法人身份证
     */
    FJLX_QYZCFRSFZ(1208, "企业注册法人身份证"),
    /**
     * 企业注册代理人身份证
     */
    FJLX_QYZCDLRSFZ(1209, "企业注册代理人身份证"),
    /**
     * 抵押顺位知晓函
     */
    FJLX_DYSWZXH(1210, "抵押顺位知晓函"),
    /**
     * 抵押附表
     */
    FJLX_DYFB(1211, "抵押附表"),
    /**
     * 抵押申请单
     */
    FJLX_DYSQD(1212, "抵押申请单"),
    /**
     * 抵押收件单
     */
    FJLX_DYSJD(1213, "抵押收件单"),
    /**
     * 电子缴款书
     */
    FJLX_DZJKS(1214, "电子缴款书"),
    /**
     * 电子缴款书
     */
    FJLX_DJZL(1215, "登记资料"),
    /**
     * 遗失(灭失)声明
     */
    FJLX_YSSM(1216, "遗失(灭失)声明"),
    /**
     * 婚姻事项承诺书
     */
    FJLX_HYSXCNS(1217, "婚姻事项承诺书");

    @Getter
    private Integer code;

    @Getter
    private String msg;

    public static String getMsg(String code) {
        for (FjlxEnum xq : FjlxEnum.values()) {
            if (xq.getCode().toString().equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
