package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2024/3/25
 * @description 权属状态枚举
 */
@Getter
@AllArgsConstructor
public enum QsztEnum {
    /** 临时 */
    LS("0","临时"),

    /** 现势 */
    XS("1","现势"),

    /** 注销 */
    ZX("2","注销");

    @Getter
    private String code;

    @Getter
    private String msg;

    public static String getMsg(String code) {
        for (QsztEnum xq : QsztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
