package cn.gtmap.hlw.core.enums.dict;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/8/24
 * @description
 */
@Getter
@AllArgsConstructor
public enum JnztEnum {
    /**待缴纳 */
    JNZT_DJN("0","待缴纳"),
    /**已缴纳 */
    JNZT_YJN("1","已缴纳"),
    /**无需缴纳 */
    JNZT_WXJN("6","无需缴纳"),
    /**已挂账 */
    JNZT_YGZ("7","已挂账");

    private String code;

    private String msg;

    public static String getMsg(String code) {
        for (JnztEnum xq : JnztEnum.values()) {
            if (xq.code.equals(code)) {
                return xq.getMsg();
            }
        }
        return null;
    }
}
