package cn.gtmap.hlw.core.dto.sw.hs.kunsan;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import lombok.Data;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/9/19
 * @description 房屋基本信息
 */
@Data
public class SbcxsFyjbxxVO {
    /**
     * 楼层
     */
    private String lc2;
    /**
     * 单元号
     */
    private String dyh;
    /**
     * 房屋幢号
     */
    private String fwzh;
    /**
     * 朝向代码
     */
    @ZdDzConfig(field = "cxDm", tableName = ZdDzConstant.ZD_DZ_FWCX, dmToDm = true, defaultValue = "02")
    private String cxDm;
    /**
     * 街道乡镇代码
     */
    private String jdxzDm;
    /**
     * 房源信息来源
     */
    private String fyxxly;
    /**
     * 土地使用证编号
     */
    private String tdsyzbh;
    /**
     * 房间号
     */
    private String fh;
    /**
     * 行政区划代码
     */
    private String xzqhszDm;
    /**
     * 房源基本信息UUID
     */
    private String fyjbxxuuid;
    /**
     * 土地房屋地址
     */
    private String tdfwdz;
    /**
     * 建筑结构代码
     */
    @ZdDzConfig(field = "jzjglxDm", tableName = ZdDzConstant.ZD_DZ_FWJG, dmToDm = true)
    private String jzjglxDm;
    /**
     * 外系统id
     */
    private String wxtid;
    /**
     * 面积
     */
    private String mj;
    /**
     * 主房标志
     */
    private String zfbz1;
    /**
     * 套内面积
     */
    private String tnmj;
    /**
     * 备注
     */
    private String bz;
    /**
     * 房源编号
     */
    private String fybh;
    /**
     * 房屋类型代码
     */
    private String fwlxDm1;
}
