package cn.gtmap.hlw.core.dto.sw.hs;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2023/7/18
 * @description 婚姻信息
 */
@Data
public class SwHsHyxxDTO {
    /**
     * 交易方 UUID
     */
    private String jyfuuid;
    /**
     * 转让方承受方标志
     */
    private String zrfcsfbz;
    /**
     * 纳税人识别号码
     */
    private String nsrsbh;
    /**
     * 纳税人名称
     */
    private String nsrmc;
    /**
     * 身份证件类型代码
     */
    @ZdDzConfig(field="sfzjlxd", tableName = ZdDzConstant.ZD_DZ_ZJLX, dmToDm = true)
    private String sfzjlxd;
    /**
     * 身份证件号码
     */
    private String sfzjhm;
    /**
     * 国籍代码
     */
    @ZdDzConfig(field="gjdm", tableName = ZdDzConstant.ZD_DZ_GJ, dmToDm = true)
    private String gjdm;
    /**
     * 配偶国籍代码
     */
    private String pogjdm;
    /**
     * 配偶证件类型
     */
    @JSONField(name = "pozjlx_dm")
    @ZdDzConfig(field="pozjlxdm", tableName = ZdDzConstant.ZD_DZ_ZJLX, dmToDm = true)
    private String pozjlxdm;
    /**
     * 配偶证件号码
     */
    private String pozjhm;
    /**
     * 配偶姓名
     */
    private String poxm;
}
