package cn.gtmap.hlw.core.dto.sqxx.save;

import cn.gtmap.hlw.core.annotation.UserAuthFilter;
import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.annotation.validator.IdCardCheck;
import cn.gtmap.hlw.core.constant.Constants;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import cn.gtmap.hlw.core.constant.role.RoleConstant;
import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/7 22:12
 * @description 权利人
 */
@Data
public class QlrDTO implements Serializable {
    /**
     * 权利人ID
     */
    private String qlrid;

    /**
     * 申请ID
     */
    private String sqid;

    /**
     * 权利人名称
     */
    private String qlrmc;

    /**
     * 权利人身份证件种类；字典项D
     */
    @ZdTypeConfig(field = "qlrsfzjzl", tableName = ZdTypeConstant.ZD_TYPE_ZJLX, mcToDM = true)
    private String qlrsfzjzl;

    /**
     * 权利人身份证件种类名称；字典项D
     */
    @ZdTypeConfig(field = "qlrsfzjzl", tableName = ZdTypeConstant.ZD_TYPE_ZJLX, dmToMc = true)
    private String qlrsfzjzlmc;

    /**
     * 权利人证件号
     */
    @UserAuthFilter(roles = RoleConstant.USERFILTER_ROLE)
    private String qlrzjh;

    /**
     * 权利人通讯地址
     */
    private String qlrtxdz;

    /**
     * 权利人类型(1:权利人，2义务人，3抵押权人,4借款人)
     */
    private String qlrlx;

    /**
     * 权利比例
     */
    private String qlbl;

    /**
     * @Pattern(regexp = "^$|[1]([3-9])[0-9]{9}$|^\\d{3}-\\d{7,8}|\\d{4}-\\d{7,8}$", message = "用户手机号不合法")
     */
    private String qlrlxdh;

    /**
     * 适用于组合登记类型
     */
    private String zdjlx;

    private String dlrdh;

    /**
     * 代理人名称
     */
    private String dlrmc;

    private String fddbrhfzrdh;

    /**
     * 法定代表人或负责人
     */
    private String fddbrhfzr;

    /**
     * 权利人邮编号
     */
    private String qlryb;

    private String dlrzjh;

    private String fddbrhfzrzjh;

    /**
     * 代理机构名称
     */
    private String dljgmc;

    /**
     * 房屋套次
     */
    private String fwtc;

    /**
     * 房屋套次名称
     */
    @ZdTypeConfig(field = "fwtc", tableName = ZdTypeConstant.ZD_TYPE_FWTC, dmToMc = true)
    private String fwtcmc;

    /**
     * 实际房屋套次
     */
    private String sjfwtc;

    /**
     * 是否本地户籍（0:否，1：是）
     */
    private String sfbdhj;

    /**
     * 权利人名称脱敏
     */
    private String qlrmcTm;

    /**
     * 权利人证件号脱敏
     */
    private String qlrzjhTm;

    /**
     * 权利人联系电话脱敏
     */
    private String qlrlxdhTm;

    /**
     * 权利人通讯地址脱敏
     */
    private String qlrtxdzTm;

    /**
     * 代理人名称脱敏
     */
    private String dlrmcTm;

    /**
     * 代理人电话脱敏
     */
    private String dlrdhTm;

    /**
     * 代理人证件号脱敏
     */
    private String dlrzjhTm;

    /**
     * 法定代表人或负责人脱敏
     */
    private String fddbrhfzrTm;

    /**
     * 法定代表人或负责人电话脱敏
     */
    private String fddbrhfzrdhTm;

    /**
     * 法定代表人或负责人证件号脱敏
     */
    private String fddbrhfzrzjhTm;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 税号
     */
    private String sh;

    /**
     * 婚姻状态
     */
    private String hyzt;

    /**
     * 代理人身份证件种类
     */
    @ZdTypeConfig(field = "dlrsfzjzl", tableName = ZdTypeConstant.ZD_TYPE_ZJLX, mcToDM = true)
    private String dlrsfzjzl;

    /**
     * 代理人身份证件种类名称
     */
    @ZdTypeConfig(field = "dlrsfzjzl", tableName = ZdTypeConstant.ZD_TYPE_ZJLX, dmToMc = true)
    private String dlrsfzjzlmc;

    /**
     * 共有方式
     */
    @ZdDzConfig(field = "gyfs", tableName = ZdDzConstant.ZD_DZ_GYFS, mcToDM = true)
    private String gyfs;

    /**
     * 税款减免（0 否 1 是 ）
     */
    private String skjm;

    /**
     * 房产证号(主要是为了适应分别持证情况）
     */
    private String fczh;

    /**
     * 是否存在家庭成员（0：是 1：否）
     */
    private String sfczjtcy;

    /**
     * 契税满两年 0 未满两年 1 满两年 放代码
     */
    private String qsmln;

    /**
     * 是否完税（0 是 1 否 ）
     */
    private String sfws;

    /**
     * 是否有税号
     */
    private String sfczsh;

    /**
     * 法定代表人或负责人ID
     */
    private String fddbrhfzrid;

    /**
     * 国籍代码
     */
    private String gjdm;

    /**
     * 主产权人标志 （0:不是主产权人，1：是主产权人，2：隐形共有人）
     */
    private String zcqrbz;

    /**
     * 国籍名称
     */
    private String gjmc;

    /**
     * 完税状态(税务):1完税，0未完税
     */
    private String wszt;

    /**
     * 是否直系亲属sfzxqs  0 否 1 是 放代码
     */
    private String sfzxqs;

    /**
     * 修改人USER_GUID
     */
    private String updateUserGuid;

    private Date updateDate;

    /**
     * 法定代表人或负责人身份证件种类
     */
    @ZdTypeConfig(field = "fddbrhfzrsfzjzl", tableName = ZdTypeConstant.ZD_TYPE_ZJLX, mcToDM = true)
    private String fddbrhfzrsfzjzl;

    /**
     * 持证方式
     */
    private String czfs;

    /**
     * 权利人种类代码（1个人、2企业、3法院、4事业单位、5国家机关、6其他）
     */
    private String gxrzldm;

    /**
     * 是否需要核验0:是；1：否--前端页面勾选
     */
    private String sfxyhy;

    /**
     * 顺序号
     */
    private String sxh;

    /**
     * 分房婚姻状态代码
     */
    private String ffhyzt;

    /**
     * 组合贷时，标识公积金、银行等抵押顺序
     */
    private String dysx;

    /**
     * 是否缴税（0 是 1 否 ）
     */
    private String sfjs;

    /**
     * 抵押权人类别(组合贷时标识抵押权人类别：1:公积金，2：银行）
     */
    private String dyqrlb;

    /**
     * 是否具备购房资格，1是；0否
     */
    private String sfjbgfzg;

    /**
     * 父组织ID(gx_yy_org.PARENT_ORG_ID)
     */
    private String parentOrgId;

    /**
     * 权利人部门名称
     */
    private String qlrorgmc;

    /**
     * 是否开票（0:否,1:是）
     */
    private String sfkp;

    /**
     * 是否小微企业（0:否,1:是）
     */
    private String sfxwqy;

    /**
     * 权利人电子邮箱
     */
    private String qlrEmail;

    /**
     * 是否月结(0:否；1:是)
     */
    private String sfyj;

    /**
     * 完税证明获取方式（ 0：上传税票；1：输入契税完税凭证的电子税票号核税；）
     */
    private String wszmhqfs;

    /**
     * 税款减免原因
     */
    private String skjmyy;

    /**
     * 税款减免登记费，1是（减免）0否
     */
    private String skjmdjf;

    /**
     * 是否打印纸质证书（1:是，0：否）
     */
    private String sfdyzzzs;

    /**
     * 申请书内容
     */
    private String sqsnr;

    private String sfht;

    /**
     * 购买方直系亲属标志(gx_yy_zd_type.GMFZXQSBZ)
     */
    private String gmfzxqsbz;

    /**
     * 代理人ID
     */
    private String dlrid;

    /**
     * 申报房屋套次
     */
    private String sbfwtc;

    /**
     * 委托事项（代码）
     */
    private String wtsx;

    /**
     * 邮寄地址
     */
    private String yjdz;

    /**
     * 权利人特征
     */
    private String qlrtz;

    /**
     * 购买住房限购协查申请（买方1：是；0：否）
     */
    private String sfxcsq;

    /**
     * 核验材料编码（人才编码）
     */
    private String hyclbh;

    /**
     * 税务约定份额
     */
    private String swydfe;

    /**
     * 是否购买两年
     */
    private String sfgmln;

    /**
     * 人证比对结果：0：无需比对，1：未比对，2：比对通过，3：比对未通过
     */
    private String rzbdjg;

    /**
     * 数据来源（0：用户手填，1：第三方共享）
     */
    private String sjly;

    @JSONField(serialize = false)
    private String qlrzjhAndZjlx;

    @IdCardCheck
    public String getQlrzjhAndZjlx() {
        return qlrzjh + Constants.DASH + qlrsfzjzl;
    }

    /**
     * 家庭成员
     */
    private List<QlrJtcyDTO> jtcyList;

    /**
     * 监护人
     */
    private List<QlrJhrDTO> jhrList;

    /**
     * 义务人与权利人关系--gx_yy_zd_type.YWRYQLRGX
     */
    private String ywryqlrgx;
    /**
     * 是否领证人
     */
    private String sflzr;
    /**
     * 人证对比相似度
     */
    private String rzbdxsd;
    /**
     * 人证比对时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    private Date rzbdsj;

    /**
     * 是否云签
     */
    private String sfyq;

    /**
     * 代理起始日期
     */
    private String dlqsrq;

    /**
     * 代理结束日期
     */
    private String dljsrq;

    /**
     * 关系人姓名
     */
    private String gxrmc;
    /**
     * 关系人身份证件种类(代码)
     */
    private String gxrsfzjzl;
    /**
     * 关系人证件号
     */
    private String gxrzjh;
    /**
     * 关系人类型(1:代理人)
     */
    private String gxrlx;
    /**
     * 关系人联系电话
     */
    private String gxrlxdh;
    /**
     * 云签方式（0：单独云签 1：批量云签）
     */
    private String yqfs;
    /**
     * 是否认证（0:是 认证通过，1：否 未认证，2:驳回,3:待认证-银行认证通过后个人核验,4:待认证-个人核验后银行核验）
     */
    private String sfrz;
    /**
     * 是否签章（0:未签章，1:签章完成;2:签章失败 3:拒签）
     */
    private String sfqz;
    /**
     * 配偶证件号
     */
    private String poZjh;
    /**
     * 个税申报方式（1：差额征收、2：全额征收）
     */
    private String gssbfs;
    /**
     * 交易方式
     */
    private String jyfs;
    /**
     * 户籍所在省
     */
    private String hjszs;
    /**
     * 户籍所在地市
     */
    private String hjszds;
    /**
     * 户籍所在地县
     */
    private String hjszdx;
    /**
     * 权利人性别
     */
    private String qlrxb;
}
