package cn.gtmap.hlw.core.dto.sqxx.save;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/7 22:04
 * @description 房屋信息
 */
@Data
public class FwxxDTO implements Serializable {
    /**
     * 受理编号 （与sqxx表关联）
     */
    private String slbh;

    /**
     * 房屋幢号
     */
    private String fwzh;

    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 产权证号
     */
    private String cqzhList;

    /**
     * 定着物面积
     */
    private String dzwmj;

    /**
     * 查封范围
     */
    private String cffw;

    /**
     * 不动产类型
     */
    private String bdclx;

    /**
     * 不动产类型名称
     */
    @ZdTypeConfig(field = "bdclx", tableName = ZdTypeConstant.ZD_TYPE_BDCLX, dmToMc = true)
    private String bdclxmc;

    /**
     * 坐落
     */
    private String zl;

    /**
     * 房屋房号
     */
    private String fwfh;

    /**
     * 房屋总层数
     */
    private String fwzcs;

    /**
     * 房屋所在层
     */
    private String fwszc;

    /**实测建筑面积*/
    private String jzmj;

    /** 宗地面积*/
    private String zdmj;

    /**实测套内面积*/
    private String sctnmj;

    /**实测分摊面积*/
    private String scftmj;

    /**房屋用途*/
    private String fwyt;

    /**
     * 房屋用途名称
     */
    @ZdTypeConfig(field = "fwyt", tableName = ZdTypeConstant.ZD_TYPE_FWYT, dmToMc = true)
    private String fwytmc;
    /**房屋性质*/
    private String fwxz;
    /**
     * 房屋性质名称
     */
    @ZdTypeConfig(field = "fwxz", tableName = ZdTypeConstant.ZD_TYPE_FWXZ, dmToMc = true)
    private String fwxzmc;

    /**预测建筑面积*/
    private String ycjzmj;

    private String jznf;

    /**房屋面积*/
    private String fwmj;

    /**房屋结构*/
    private String fwjg;
    /**
     * 房屋结构名称
     */
    @ZdTypeConfig(field = "fwjg", tableName = ZdTypeConstant.ZD_TYPE_FWJG, dmToMc = true)
    private String fwjgmc;

    /**房屋类型*/
    private String fwlx;
    /**
     * 房屋类型名称
     */
    @ZdTypeConfig(field = "fwlx", tableName = ZdTypeConstant.ZD_TYPE_FWLX, dmToMc = true)
    private String fwlxmc;

    /**申请ID*/
    private String sqid;

    /**竣工时间*/
    private String jgsj;

    /**行政区划*/
    private String xzqhdm;

    @ZdTypeConfig(field = "xzqhdm", tableName = ZdTypeConstant.ZD_TYPE_XZQH, dmToMc = true)
    private String xzqhmc;

    /**所有权人*/
    private String syqr;

    /**房屋单元号*/
    private String fwdyh;

    /**阁楼面积*/
    private Double glmj;

    /**储藏室面积*/
    private Double ccsmj;

   /**自行车车库面积*/
    private Double zxcckmj;

    /**汽车车库面积*/
    private Double qcckmj;

    /**房屋朝向代码*/
    private String fwcxdm;

     /**规划用途代码*/
    private String ghytdm;
    /**
     * 规划用途名称
     */
    @ZdTypeConfig(field = "ghytdm", tableName = ZdTypeConstant.ZD_TYPE_GHYT, dmToMc = true)
    private String ghytmc;

    /**房屋信息来源*/
    private String fwxxly;

    /**不动产项目名称*/
    private String bdcxmmc;

    /**权利性质代码*/
    private String qlxzdm;

    /**所在乡镇街道*/
    private String szxzjd;

    /**是否按揭(0：否，1：是)*/
    private String sfaj;

   /**房屋实际层（与房屋所在层区分）*/
    private String fwsjc;

    /**独用建筑面积 包括分摊面积，套内面积是实际使用面积*/
    private String dyjzmj;

    /**预测分摊面积*/
    private String ycftmj;

    /**预测套内面积*/
    private String yctnmj;

    /**是否有电梯0无1有*/
    private String isdt;

    /**房屋类别代码1高层2多层3别墅4平房5其他*/
    private String fwlbdm;

    /**区域代码*/
    private String qydm;

    /**是否多本证*/
    private String sfdbz;

    /**小区名称*/
    private String xqmc;

    /**权属转移方式(同登记原因)*/
    private String qszyfs;

    /**权属转移对象*/
    private String qszydx;

    /**权属转移用途*/
    private String qszyyt;

    /**是否临街（1：临街 2：不临街）*/
    private String sflj;

    /**是否顶层，1是0否*/
    private String sfdc;

    /**建成年份*/
    private String jcnf;

    /**业务小类（存放代码）*/
    private String ywxl;

    /**取得方式（存放代码）*/
    private String qdfs;

    /**
     * 其他权利状况
     */
    private String qtqlzk;

    /**
     * 装修状况（存代码，字典项）
     */
    private String zxzk;

    /**宗地用途代码*/
    private String zdytdm;

    /**宗地用途名称*/
    @ZdTypeConfig(field = "zdytdm", tableName = ZdTypeConstant.ZD_TYPE_TDYT, dmToMc = true)
    private String zdytmc;

    /**幢附着物代码*/
    private String zfzwdm;

    /**幢不动产单元号*/
    private String zbdcdyh;

    /**房屋编号，同houseid*/
    private String fwid;

    /**变动份额*/
    private Double bdfe;

    /**租赁情况（zd_type表对照）*/
    private String zlqk;

    /**承租人*/
    private String czr;

    /**抵押情况（zd_type表对照）*/
    private String dyqk;

    /**居住权情况（zd_type表对照）*/
    private String jzqqk;

    /**契税权属转移类别代码*/
    private String qsqszylbdm;

    /**契税权属转移对象代码*/
    private String qsqszydxdm;

    /**
     * 契税权属转移用途代码
     */
    private String qsqszyytdm;

    /**道路名称*/
    private String dlmc;

    /**物业类型*/
    private String wylx;

    /**承包面积*/
    private Double cbmj;

    /**地块名称*/
    private String dkmc;

    /**承包地类等级*/
    private String cbdldj;

    /**确权情况(1：确权确股，2：确权确地)*/
    private String qqqk;

    /**实测面积*/
    private Double scmj;

    /**地块编码*/
    private String dkbm;

    /**是否基本农田*/
    private String sfjbnt;

    /**承包使用开始时间*/
    private String cbsykssj;

    /**承包使用结束时间*/
    private String cbsyjssj;

    /**承包土地用途*/
    private String cbtdyt;

    /**承包土地用途名称*/
    @ZdTypeConfig(field = "cbtdyt", tableName = ZdTypeConstant.ZD_TYPE_CBTDYT, dmToMc = true)
    private String cbtdytmc;

    /**地块四至*/
    private String dksz;

    /**经营使用开始时间*/
    private String jyqxkssj;

    /**经营使用结束时间*/
    private String jyqxjssj;
    /**
     * 经营面积
     */
    private Double jymj;
    /**
     * 经营用途
     */
    private String jyyt;
    /**
     * 经营用途名称
     */
    @ZdTypeConfig(field = "jyyt", tableName = ZdTypeConstant.ZD_TYPE_JYYT, dmToMc = true)
    private String jyytmc;
    /**
     * 宗地权利类型
     */
    private String zdzhqllx;
    /**
     * 宗地权利类型名称
     */
    @ZdTypeConfig(field = "zdzhqllx", tableName = ZdTypeConstant.ZD_TYPE_ZDZHQLLX, dmToMc = true)
    private String zdzhqllxmc;
    /**
     * 林种
     */
    private String lz;
    /**
     * 林地使用开始期限
     */
    private Date ldsyksqx;
    /**
     * 林地使用结束期限
     */
    private Date ldsyjsqx;
    /**
     * 林地使用期限是否永久
     */
    private String ldsyqxsfyj;
    /**
     * 主要树种
     */
    private String zysz;
    /**
     * 森林类别名称
     */
    private String sllbmc;
    /**
     * 森林类别代码
     */
    private String sllbdm;
    /**
     * 事权等级
     */
    private String sqdj;
    /**
     * 小地名
     */
    private String xdm;
    /**
     * 起源
     */
    private String qy;
    /**
     * 株数
     */
    private String zs;
    /**
     * 林班
     */
    private String lb;
    /**
     * 小班
     */
    private String xb;
    /**
     * 权利类型
     */
    private String qllx;
    /**
     * 造林年度
     */
    private String zlnd;
    /**
     * 附记
     */
    private String fj;
    /**
     * 项目id
     */
    private String xmid;
    /**
     * 面积
     */
    private String mj;
    /**
     * 发包方名称
     */
    private String fbfmc;
    /**
     * 森林、林木使用人
     */
    private String sllmsyr;
    /**
     * 森林、林木所有权人
     */
    private String sllmsyqr;

    /**是否逻辑幢（1：是， 0：否）*/
    private String sfljz;

    /**房屋交付使用备案证书号*/
    private String jfbazsh;

    /**房屋交付备案证书发证日期*/
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date jfbafzrq;


    /**租赁期限（YYYY-MM-DD）*/
    private String zlqx;

    /**是否租赁（1是 0否）*/
    private String sfzl;
    /**
     * 挂牌价格
     */
    private Double gpjg;
    /**
     * 房屋户型
     */
    private String fwhx;
}
