package cn.gtmap.hlw.core.dto.sqxx.push.dj3;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/9/10 20:26
 * @description PushDj3WlxxParamsBO
 */
@Data
public class PushDj3WlxxParamsBO {
    /**
     * 1:EMS邮寄，2:窗口领证，3:自助打印机，4:电子证照
     */
    @ApiModelProperty(value = "领证方式代码", required = false)
    @ZdDzConfig(field = "lzfsdm", tableName = ZdDzConstant.ZD_DZ_LZFS, dmToDm = true)
    private String lzfsdm;
    @ApiModelProperty(value = "领证方式名称", required = false)
    private String lzfsmc;
    @ApiModelProperty(value = "收件人联系电话", required = false)
    private String sjrlxdh;
    @ApiModelProperty(value = "收件人名称", required = false)
    private String sjrmc;
    @ApiModelProperty(value = "收件人所在市", required = false)
    private String sjrszshi;
    @ApiModelProperty(value = "收件人所在省", required = false)
    private String sjrszsheng;
    @ApiModelProperty(value = "收件人所在县", required = false)
    private String sjrszx;
    @ApiModelProperty(value = "收件人详细地址", required = false)
    private String sjrxxdz;
    @ApiModelProperty(value = "领证人名称", required = false)
    private String lzrmc;
    @ApiModelProperty(value = "领证人证件种类", required = false)
    private String lzrzjzl;
    @ApiModelProperty(value = "领证人证件号", required = false)
    private String lzrzjh;
    @ApiModelProperty(value = "申请id", required = false)
    private String sqid;
    @ApiModelProperty(value = "物流id", required = false)
    private String wlid;
    @ApiModelProperty(value = "13 领证人联系电话", required = false)
    private String lzrlxdh;
    @ApiModelProperty(value = "14 领证详细地址", required = false)
    private String lzxxdz;
    /**
     * 电子邮箱（收件人）
     */
    private String dzyx;
    private String lzrzjzldm;
    private String lzrzjzlmc;
    /**
     * 收件人证件号
     */
    private String sjrzjh;
    /**
     * 是否委托
     */
    private String sfwt;

    /**
     * 收件人邮编
     */
    private String sjryb;

    /**
     * 领证人委托开始日期
     */
    private String lzrwtksrq;

    /**
     * 领证人委托结束日期
     */
    private String lzrwtjsrq;
}
