package cn.gtmap.hlw.core.dto.sqxx.push.dj3;

import cn.gtmap.hlw.core.annotation.ZdDzConfig;
import cn.gtmap.hlw.core.constant.dict.ZdDzConstant;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import cn.gtmap.hlw.core.dto.sqxx.push.dj2.sqxx.PushSqxxFsssxxDTO;
import cn.gtmap.hlw.core.dto.sqxx.push.dj3.dyzy.PushDj3DyZySwxxParamsBO;
import lombok.Data;

import java.util.List;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/9/10 19:43
 * @description PushDj3SqxxParamsBO
 */
@Data
public class PushDj3SqxxParamsBO {
    /**
     * 业务号(外网受理编号)
     */
    private String ywh;
    /**
     * 申请登记类型 Clf:存量房转移登记流程  zlf:增量房转移登记流程 dyaqsc:抵押登记设立流程 dyaqzx:抵押注销登记流程
     */
    private String sqdjlx;
    /**
     * Tt库项目id
     */
    private String ttproid;
    /**
     * 不动产单元编号
     */
    private String bdcdybh;
    /**
     * 房产合同编号
     */
    private String fchtbh;
    /**
     * 备案号
     */
    private String bah;
    /**
     * 坐落
     */
    private String zl;
    /**
     * 房产证号
     */
    private String fczh;
    /**
     * 不动产单元号
     */
    private String bdcdyh;
    /**
     * 房屋面积
     */
    private String mj;
    /**
     * 抵押状态
     */
    private String sfdy;
    /**
     * 查封状态
     */
    private String sfcf;
    /**
     * 共有方式
     */
    private String gyfs;
    /**
     * 交易价格
     */
    private String jyjg;
    /**
     * 合同签订日期
     */
    private String htqdrq;
    /**
     * 合同备案时间
     */
    private String barq;
    /**
     * 合同编号
     */
    private String htbh;
    /**
     * 抵押证明号
     */
    private String bdcdjzmh;
    /**
     * 抵押金额
     */
    private String dyje;
    /**
     * 抵押方式
     */
    private String dyfs;
    /**
     * 抵押范围
     */
    private String dyfw;
    /**
     * 抵押开始时间
     */
    private String dykssj;
    /**
     * 抵押结束时间
     */
    private String dyjssj;
    /**
     * 附件
     */
    private String fj;
    /**
     * 抵押注销原因
     */
    private String dyzxyy;
    /**
     * 合同状态htzt  0 是 已网签 传代码
     */
    private String htzt;
    /**
     * 关系人信息
     */
    @ZdDzConfig(field = "gxrxx", tableName = "", isList = true)
    private List<PushDj3SqxxGxrxxParamsBO> gxrxx;
    /**
     * 预约部门代码
     */
    private String yybmbm;
    /**
     * 区域代码
     */
    private String dwdm;
    /**
     * @author <a href="mailto:huangyongkai@gtmap.cn">huangyongkai</a>
     * @description 证书来源zsly 契税满两年 （2：新证书3：老证书）
     */
    private String zsly;
    /**
     * 契税满两年	qsmln	字符串 0 未满两年 1 满两年 放代码
     */
    private String qsmln;
    /**
     * HYK  2019年8月15日 新增项目id	xmid	字符串 存量数据主键,为3.0业务数据主键
     */
    private String xmid;
    /**
     * HYK 2019年9月26日新增22-31
     * 22	受理人	slr	字符串				调用3.0时传的用户名
     */
    @ZdDzConfig(field = "slr", tableName = ZdDzConstant.ZD_DZ_SLR, dmToDm = true, isSetBlank = true)
    private String slr;
    /**
     * 23	土地证号	tdzh	字符串l
     */
    private String tdzh;
    /**
     * 24	土地项目id	Tdxmid	字符串
     */
    private String tdxmid;
    /**
     * 25	受理来源	Slly	字符串				互联网+：wwsq，一窗受理：ycsl
     */
    private String slly;
    /**
     * 26	创建验证	cjyz	字符串				是否需要创建前验证，0不需要；1需要
     */
    private String cjyz;
    /**
     * 27	付款方式	fkfs	字符串				放名称
     */
    private String fkfs;
    /**
     * 28	自动转发	zdzf	字符串				是否自动转发向审核节点 0不转发 1转发
     */
    private String zdzf;
    /**
     * 29	登记原因代码	djyydm	字符串				登记原因字典项，放代码
     */
    private String djyydm;
    /**
     * 30	登记原因名称	djyymc	字符串				登记原因字典项，放名称
     */

    private String djyymc;
    /**
     * 31	付款方式代码	fkfsdm	字符串				付款方式字典项放代码
     */
    private String fkfsdm;
    /**
     * 预审人
     */
    private String ysr;
    /**
     * 预审时间
     */
    private String yssj;
    /**
     * 是否涉税（0 不涉税，1涉税）
     */
    private String sfss;
    /**
     * 35	预审提示信息	ystsxx	字符串
     */
    private String ystsxx;
    /**
     * 规划用途	ghyt	字符串
     */
    private String ghyt;
    /**
     * 规划用途名称	ghytmc	字符串
     */
    private String ghytmc;
    /**
     * 土地使用权类型	tdsyqlx	字符串
     */
    private String tdsyqlx;
    /**
     * 土地使用权类型名称	tdsyqlxmc	字符串
     */
    private String tdsyqlxmc;
    /**
     * 房屋结构	fwjg	字符串
     */
    private String fwjg;
    /**
     * 房屋结构名称	fwjgmc	字符串
     */
    @ZdDzConfig(field = "fwjgmc", tableName = ZdTypeConstant.ZD_TYPE_FWJG, dmToMc = true, isSetBlank = true)
    private String fwjgmc;

    /**
     * 预约开始时间
     */
    private String yykssj;
    /**
     * 预约结束时间
     */
    private String yyjssj;
    /**
     * 44	备注	bz	字符串
     */
    private String bz;
    /**
     * 45	房源编码	fybm	字符串
     */
    private String fybm;
    private String roomid;
    /**
     * 跳过节点数
     */
    private String tgjds;

    private PushDj3SqxxGhxxParamsBO ghxx;

    /**
     * 不含增值税金额
     */
    private String bhzzsje;
    /**
     * 增值税金额
     */
    private String zzsje;
    /**
     * 含增值税金额
     */
    private String hzzsje;
    /**
     * 是否分别持证
     */
    private String sffbcz;
    /**
     * 52	行政区代码	xzqdm	字符串				6位地区码，3.0
     */
    private String xzqdm;
    /**
     * 53	权籍关联代码	qjgldm	字符串				3.0
     */
    private String qjgldm;
    /**
     * 土地用途
     */
    private String tdyt;
    /**
     * 土地用途名称
     */
    private String tdytmc;
    /**
     * 土地用途2
     */
    private String tdyt2;
    /**
     * 土地用途名称2
     */
    private String tdytmc2;
    /**
     * 土地用途3
     */
    private String tdyt3;
    /**
     * 土地用途名称3
     */
    private String tdytmc3;
    /**
     * 土地使用权起始时间
     */
    private String qsrq;
    /**
     * 土地使用权结束时间
     */
    private String jsrq;
    /**
     * 土地使用权起始时间2
     */
    private String qsrq2;
    /**
     * 土地使用权结束时间2
     */
    private String jsrq2;
    /**
     * 土地使用权起始时间3
     */
    private String qsrq3;
    /**
     * 土地使用权结束时间3
     */
    private String jsrq3;
    /**
     * 申请材料提交方式
     */
    private String sqcltjfs;
    /**
     * 项目子编号
     */
    private String xmzbh;
    /**
     * 宗地面积
     */
    private String zdmj;
    /**
     * 70	是否税费托管	sfsftg	字符串				1:是，0：否
     */
    private String sfsftg;
    /**
     * 申请部门名称
     */
    private String sqbmmc;

    /**
     * 72	业务类型	ywlx	字符串
     */
    private String ywlx;
    /**
     * 73	是否需要登簿发证	sfxydbfz	字符串				1:是，0：否
     */
    private String sfxydbfz;
    /**
     * 74	是否交房即发证	sfjfjfz	字符串				放代码 ，1：是，0：否
     */

    private String sfjfjfz;
    /**
     * 75	交房即发证备注	jfjfzbz	字符串
     */
    private String jfjfzbz;
    /**
     * 76	是否一次收费后台分账	sfycsfhtfz	字符串				放代码 ，1：是，0：否
     */
    private String sfycsfhtfz;
    /**
     * 77	房屋uuid	fwuuid
     */
    private String fwuuid;
    /**
     * 78	是否摇号限售房源	sfyhxsfy	字符串				放代码 ，1：是，0：否
     */
    private String sfyhxsfy;

    /**
     * 一窗受理人名称
     */
    private String ycslrmc;
    /**
     * 一窗受理人部门名称
     */
    private String ycslrbmmc;
    /**
     * 登簿人
     */
    private String dbr;
    /**
     * 发票信息
     */
    private List<PushDj3SqxxFpxxParamsBO> fpxxList;
    /**
     * 取得价格
     */
    private String qdjg;
    /**
     * 房屋性质代码
     */
    private String fwxzdm;
    /**
     * 房屋性质名称
     */
    private String fwxzmc;
    /**
     * 房屋类型代码
     */
    private String fwlxdm;
    /**
     * 房屋类型名称
     */
    private String fwlxmc;
    /**
     * 竣工时间
     */
    private String jgsj;
    /**
     * 分摊建筑面积
     */
    private String ftjzmj;
    /**
     * 套内建筑面积
     */
    private String tnjzmj;
    /**
     * 幢号
     */
    private String zh;
    /**
     * 所在层
     */
    private String szc;
    /**
     * 总层数
     */
    private String zcs;
    /**
     * 创建人角色id
     */
    private String cjrjsid;
    /**
     * 创建人名称
     */
    private String cjrmc;
    /**
     * 生成证书类型代码
     * 1:生成证书 2：生成证明书 3：只登簿不发证（传3则sfxydbfz需要传0）
     */
    private String sczslxdm;
    /**
     * 分摊土地面积
     */
    private String fttdmj;
    /**
     * 独用土地面积
     */
    private String dytdmj;
    /**
     * 土地使用权人
     */
    private String tdsyqr;
    /**
     * 权利人ocr识别是否通过
     */
    private String qlrocrsbsftg;
    /**
     * 产权来源
     */
    private String cqlydm;
    /**
     * 产权来源名称
     */
    private String cqlymc;
    /**
     * 房间号
     */
    private String fjh;

    /**
     * 小区名称
     */
    private String xqmc;
    /**
     * 道路名称
     */
    private String dlmc;
    /**
     * 单元号
     */
    private String dyh;
    /**
     * 建筑年份
     */
    private String jznf;
    /**
     * 阁楼面积
     */
    private Double glmj;
    /**
     * 储藏室面积
     */
    private Double ccsmj;
    /**
     * 车库面积
     */
    private Double ckmj;
    /**
     * 交易方式代码
     */
    private String jyfsdm;
    /**
     * 交易方式代码
     */
    private String jyfsmc;
    /**
     * 上次取得房屋方式代码
     */
    private String scqdfwfsdm;
    /**
     * 上次取得房屋方式名称
     */
    private String scqdfwfsmc;
    /**
     * 乡镇街道代码
     */
    private String xzjddm;

    private List<PushSqxxFsssxxDTO> fsssxx;
    /**
     * 补正信息
     */
    private List<PushSqxxBzxxDTO> bzxx;
    /**
     * 维修基金信息
     */
    private PushDj3WxjjxxBO wxjjxx;

    private List<PushDj3DyZySwxxParamsBO> swxx;

    /**
     * 是否带押过户
     */
    private String sfdygh;

    /**
     * 是否提供现场服务
     */
    private String sftgxcfw;

    /**
     * 是否无还本续贷款
     */
    private String sfwhbxd;

    /**
     * 原抵押金额
     */
    private String ydyje;

    /**
     * 抵押金额类型
     */
    private String dyjelx;

    /**
     * 交付日期
     */
    private String jfrq;

    /**
     * 是否跨行带押过户（0是，1否）
     */
    private String sfkhdygh;
}
