package cn.gtmap.hlw.core.dto.exchange.query.cqxx;

import cn.gtmap.hlw.core.annotation.ZdTypeConfig;
import cn.gtmap.hlw.core.constant.dict.ZdTypeConstant;
import lombok.Data;

import java.util.Date;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/4/22
 * @description
 */
@Data
public class DyxxDTO {
    /**
     * 不动产单元编号（房屋代码）
     */
    private String bdcdybh;

    /**
     * 不动产单元号
     */
    private String bdcdyh;

    /**
     * 不动产登记证明号
     */
    private String bdcdjzmh;

    /**
     * 抵押权人
     */
    private String dyqr;

    /**
     * 抵押金额
     */
    private Double dyje;

    /**
     * 抵押开始时间 YYYY-MM-DD HH:MM:SS
     */
    private String dykssj;

    /**
     * 抵押结束时间 YYYY-MM-DD HH:MM:SS
     */
    private String dyjssj;

    /**
     * 登记时间 YYYY-MM-DD HH:MM:SS
     */
    private String djsj;

    /**
     * 权属状态 1 现势 放名称
     */
    private String qszt;

    /**
     * 附记
     */
    private String fj;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 抵押方式代码1 一般抵押 2 最高额抵押
     */
    private String dyfsdm;

    /**
     * 抵押方式名称 一般抵押 2 最高额抵押
     */
    @ZdTypeConfig(field = "dyfsdm", tableName = ZdTypeConstant.ZD_TYPE_DYFS, dmToMc = true)
    private String dyfsmc;

    /**
     * 担保范围
     */
    private String dbfw;

    /**
     * 抵押人
     */
    private String dyr;

    /**
     * 抵押合同签订日期
     */
    private String dyhtqdrq;

    /**
     * 抵押顺位
     */
    private String dysw;

    /**
     * 原项目id
     */
    private String yxmid;

    /**
     * 抵押备案合同号
     */
    private String dybahth;

    /**
     * 抵押套数
     */
    private Integer dyts;

    /**
     * 币种
     */
    private String biz;

    /**
     * 贷款方式;字典项（dm）
     */
    private String dkfs;

    @ZdTypeConfig(field = "dkfs", tableName = ZdTypeConstant.ZD_TYPE_DKFS, dmToMc = true)
    /**贷款方式名称;字典项（mc）*/
    private String dkfsmc;

    /**
     * 不动产价值
     */
    private Double bdcjz;

    /**
     * 在建建筑物抵押范围
     */
    private String zjjzwdyfw;

    /**
     * 在建建筑物坐落
     */
    private String zjjzwzl;

    /**
     * 顺序（组合贷时，标识公积金、银行等抵押顺序，1:公积金，2：银行）
     */
    private String sx;

    /**
     * 是否禁止抵押期间抵押物转让放代码，1：禁止，0：同意
     */
    private String sfjzdyqjdywzrdm;

    /**
     * 是否存在约定( 0:否  1:是)
     */
    private String sfczyd;

    /**
     * 约定内容
     */
    private String ydnr;

    private String zl;

    /**
     * 业务小类（存放代码）
     */
    private String ywxl;

    /**
     * 最高债权额）
     */
    private Double zgzqe;

    /**
     * 是否打印纸质证书（1:是，0：否）
     */
    private String sfdyzzzs;

    /**
     * 最高债权额其中土地
     */
    private String zgzqeqztd;

    /**
     * 公积金抵押金额
     */
    private String gjjdyje;

    /**
     * 公积金债务履行起始时间
     */
    private Date gjjzwlxqssj;

    /**
     * 公积金债务履行结束时间
     */
    private Date gjjzwlxjssj;

    /**
     * 权利顺序
     */
    private String qlsx;

    /**
     * 借款用途
     */
    private String jkyt;

    /**
     * 抵押金额类型
     */
    private String dyjelx;

    /**
     * 是否共同担保（1:是，0:否）
     */
    private String sfgtdb;
    /**
     * 面积
     */
    private Double mj;
    /**
     * 土地抵押面积
     */
    private String tddymj;
    /**
     * 房屋抵押面积
     */
    private String fwdymj;
    /**
     * 原抵押金额
     */
    private Double ydyje;
}
