package cn.gtmap.hlw.core.dto.exchange.push;

import cn.hutool.core.date.DatePattern;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @version 1.0, 2025/3/25
 * @description 附件信息
 */
@Data
public class PushFjxxDTO {
    /**
     * 主键
     */
    private String fjid;
    /**
     * 附件名称
     */
    private String fjmc;
    /**
     * fjxm.id
     */
    private String xmid;

    /**附件类型（gx_yy_zd_fj.dm或者页面生成各地区唯一附件类型代码）*/
    private String fjlx;
    /**
     * 附件路径
     */
    private String filepath;
    /**
     * 附件名称
     */
    private String filemc;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    private Date createDate;
    /**
     * 创建人
     */
    private String createUser;
    /**
     * 申请id
     */
    private String sqid;

    /**文件中心ID*/
    private String wjzxId;

    /**文件中心下载URL*/
    private String wjzxDownUrl;

    /**ftp上传url*/
    private String ftpUrl;

    /**文件中心附件名称（带后缀）*/
    private String wjzxFjmc;

    /**是否为部门附件;0否,1是*/
    private String sfbmfj;

    /**文件中心顺序号(传给登记的顺序)*/
    private Integer wjzxSxh;

    /**文件中心存储状态（0:未上传，1：上传中，2：已上传,3:已失效）*/
    private String wjzxcczt;

    /**附件来源0:互联网；1:登记系统，2:交易系统,3:e签名，4:税务系统5系统自动生成*/
    private String fjly;

    /**审核状态（0:未审核，1：审核中，2：审核通过，3:审核未通过）*/
    private String shzt;

    /**干系人证件号*/
    private String qlrzjhList;

    /**
     * 附件地址
     */
    private String url;

    /**IP地址*/
    private String ip;

    /**MAC地址*/
    private String mac;
}
