package cn.gtmap.hlw.core.dto.dict.jfxm;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * @author <a href="mailto:wangxuebiao@gtmap.cn">wangxuebiao</a>
 * @version 2023/6/26 16:05
 * @description ZdJfxmResultDTO
 */
@Data
public class ZdJfxmResultDTO {
    /**主键 */
    private String id;

    /**执收单位代码*/
    private String zsdwdm;

    /**执收单位名称*/
    private String zsdwmc;

    /**收费项目代码*/
    private String sfxmdm;

    /**收费项目名称*/
    private String sfxmmc;

    /**单位代码*/
    private String dwdm;

    /**单位名称 */
    private String dwmc;

    /**标准(元)*/
    private String bz;

    /**数据来源（默认HLW：互联网）gx_yy_xtjr.xtdm*/
    private String sjly;

    /**是否删除（0:未删除，1：删除）*/
    private Integer isDelete;

    /**创建时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**修改时间*/
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /**创建人员(gx_yy_user.USER_GUID)*/
    private String createUser;

    /**修改人员(gx_yy_user.USER_GUID)*/
    private String updateUser;

    /**区域代码*/
    private String qydm;

    /**开票用户*/
    private String kpyh;

    /**缴费项目代码（1：住宅类不动产登记收费;2：非住宅类不动产登记收费;3：工本费）*/
    private String jfxmdm;
}
